@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.polly.kotlin

import com.pulumi.aws.polly.PollyFunctions.getVoicesPlain
import com.pulumi.aws.polly.kotlin.inputs.GetVoicesPlainArgs
import com.pulumi.aws.polly.kotlin.inputs.GetVoicesPlainArgsBuilder
import com.pulumi.aws.polly.kotlin.inputs.GetVoicesVoice
import com.pulumi.aws.polly.kotlin.outputs.GetVoicesResult
import com.pulumi.aws.polly.kotlin.outputs.GetVoicesResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

public object PollyFunctions {
    /**
     * Data source for managing an AWS Polly Voices.
     * ## Example Usage
     * ### Basic Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.polly.getVoices({});
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.polly.get_voices()
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Polly.GetVoices.Invoke();
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/polly"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := polly.GetVoices(ctx, nil, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.polly.PollyFunctions;
     * import com.pulumi.aws.polly.inputs.GetVoicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PollyFunctions.getVoices();
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:polly:getVoices
     *       Arguments: {}
     * ```
     * <!--End PulumiCodeChooser -->
     * ### With Language Code
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.polly.getVoices({
     *     languageCode: "en-GB",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.polly.get_voices(language_code="en-GB")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Polly.GetVoices.Invoke(new()
     *     {
     *         LanguageCode = "en-GB",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/polly"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := polly.GetVoices(ctx, &polly.GetVoicesArgs{
     * 			LanguageCode: pulumi.StringRef("en-GB"),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.polly.PollyFunctions;
     * import com.pulumi.aws.polly.inputs.GetVoicesArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = PollyFunctions.getVoices(GetVoicesArgs.builder()
     *             .languageCode("en-GB")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:polly:getVoices
     *       Arguments:
     *         languageCode: en-GB
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getVoices.
     * @return A collection of values returned by getVoices.
     */
    public suspend fun getVoices(argument: GetVoicesPlainArgs): GetVoicesResult =
        toKotlin(getVoicesPlain(argument.toJava()).await())

    /**
     * @see [getVoices].
     * @param engine Engine used by Amazon Polly when processing input text for speech synthesis. Valid values are `standard`, `neural`, and `long-form`.
     * @param includeAdditionalLanguageCodes Whether to return any bilingual voices that use the specified language as an additional language.
     * @param languageCode Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
     * @param voices List of voices with their properties. See `voices` Attribute Reference below.
     * @return A collection of values returned by getVoices.
     */
    public suspend fun getVoices(
        engine: String? = null,
        includeAdditionalLanguageCodes: Boolean? = null,
        languageCode: String? = null,
        voices: List<GetVoicesVoice>? = null,
    ): GetVoicesResult {
        val argument = GetVoicesPlainArgs(
            engine = engine,
            includeAdditionalLanguageCodes = includeAdditionalLanguageCodes,
            languageCode = languageCode,
            voices = voices,
        )
        return toKotlin(getVoicesPlain(argument.toJava()).await())
    }

    /**
     * @see [getVoices].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;polly&#46;kotlin&#46;inputs&#46;GetVoicesPlainArgs].
     * @return A collection of values returned by getVoices.
     */
    public suspend fun getVoices(argument: suspend GetVoicesPlainArgsBuilder.() -> Unit): GetVoicesResult {
        val builder = GetVoicesPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getVoicesPlain(builtArgument.toJava()).await())
    }
}
