@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.polly.kotlin.inputs

import com.pulumi.aws.polly.inputs.GetVoicesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getVoices.
 * @property engine Engine used by Amazon Polly when processing input text for speech synthesis. Valid values are `standard`, `neural`, and `long-form`.
 * @property includeAdditionalLanguageCodes Whether to return any bilingual voices that use the specified language as an additional language.
 * @property languageCode Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
 * @property voices List of voices with their properties. See `voices` Attribute Reference below.
 */
public data class GetVoicesPlainArgs(
    public val engine: String? = null,
    public val includeAdditionalLanguageCodes: Boolean? = null,
    public val languageCode: String? = null,
    public val voices: List<GetVoicesVoice>? = null,
) : ConvertibleToJava<com.pulumi.aws.polly.inputs.GetVoicesPlainArgs> {
    override fun toJava(): com.pulumi.aws.polly.inputs.GetVoicesPlainArgs =
        com.pulumi.aws.polly.inputs.GetVoicesPlainArgs.builder()
            .engine(engine?.let({ args0 -> args0 }))
            .includeAdditionalLanguageCodes(includeAdditionalLanguageCodes?.let({ args0 -> args0 }))
            .languageCode(languageCode?.let({ args0 -> args0 }))
            .voices(
                voices?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetVoicesPlainArgs].
 */
@PulumiTagMarker
public class GetVoicesPlainArgsBuilder internal constructor() {
    private var engine: String? = null

    private var includeAdditionalLanguageCodes: Boolean? = null

    private var languageCode: String? = null

    private var voices: List<GetVoicesVoice>? = null

    /**
     * @param value Engine used by Amazon Polly when processing input text for speech synthesis. Valid values are `standard`, `neural`, and `long-form`.
     */
    @JvmName("hmntcblikmbjbvas")
    public suspend fun engine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.engine = mapped
    }

    /**
     * @param value Whether to return any bilingual voices that use the specified language as an additional language.
     */
    @JvmName("bfmdjpsragqlvxpg")
    public suspend fun includeAdditionalLanguageCodes(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeAdditionalLanguageCodes = mapped
    }

    /**
     * @param value Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
     */
    @JvmName("gfqtwxybsvstbphb")
    public suspend fun languageCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.languageCode = mapped
    }

    /**
     * @param value List of voices with their properties. See `voices` Attribute Reference below.
     */
    @JvmName("idqasjdhmshivyxu")
    public suspend fun voices(`value`: List<GetVoicesVoice>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.voices = mapped
    }

    /**
     * @param argument List of voices with their properties. See `voices` Attribute Reference below.
     */
    @JvmName("roupnhsoamxakgoe")
    public suspend fun voices(argument: List<suspend GetVoicesVoiceBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { GetVoicesVoiceBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.voices = mapped
    }

    /**
     * @param argument List of voices with their properties. See `voices` Attribute Reference below.
     */
    @JvmName("dioepjpdyoukyoya")
    public suspend fun voices(vararg argument: suspend GetVoicesVoiceBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { GetVoicesVoiceBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.voices = mapped
    }

    /**
     * @param argument List of voices with their properties. See `voices` Attribute Reference below.
     */
    @JvmName("bfayiqfvakdeaick")
    public suspend fun voices(argument: suspend GetVoicesVoiceBuilder.() -> Unit) {
        val toBeMapped = listOf(GetVoicesVoiceBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.voices = mapped
    }

    /**
     * @param values List of voices with their properties. See `voices` Attribute Reference below.
     */
    @JvmName("gjofrxxphquuktdh")
    public suspend fun voices(vararg values: GetVoicesVoice) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.voices = mapped
    }

    internal fun build(): GetVoicesPlainArgs = GetVoicesPlainArgs(
        engine = engine,
        includeAdditionalLanguageCodes = includeAdditionalLanguageCodes,
        languageCode = languageCode,
        voices = voices,
    )
}
