@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.polly.kotlin.inputs

import com.pulumi.aws.polly.inputs.GetVoicesVoice.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property additionalLanguageCodes Additional codes for languages available for the specified voice in addition to its default language.
 * @property gender Gender of the voice.
 * @property id Amazon Polly assigned voice ID.
 * @property languageCode Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
 * @property languageName Human readable name of the language in English.
 * @property name Name of the voice.
 * @property supportedEngines Specifies which engines are supported by a given voice.
 */
public data class GetVoicesVoice(
    public val additionalLanguageCodes: List<String>,
    public val gender: String,
    public val id: String,
    public val languageCode: String,
    public val languageName: String,
    public val name: String,
    public val supportedEngines: List<String>,
) : ConvertibleToJava<com.pulumi.aws.polly.inputs.GetVoicesVoice> {
    override fun toJava(): com.pulumi.aws.polly.inputs.GetVoicesVoice =
        com.pulumi.aws.polly.inputs.GetVoicesVoice.builder()
            .additionalLanguageCodes(additionalLanguageCodes.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .gender(gender.let({ args0 -> args0 }))
            .id(id.let({ args0 -> args0 }))
            .languageCode(languageCode.let({ args0 -> args0 }))
            .languageName(languageName.let({ args0 -> args0 }))
            .name(name.let({ args0 -> args0 }))
            .supportedEngines(supportedEngines.let({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [GetVoicesVoice].
 */
@PulumiTagMarker
public class GetVoicesVoiceBuilder internal constructor() {
    private var additionalLanguageCodes: List<String>? = null

    private var gender: String? = null

    private var id: String? = null

    private var languageCode: String? = null

    private var languageName: String? = null

    private var name: String? = null

    private var supportedEngines: List<String>? = null

    /**
     * @param value Additional codes for languages available for the specified voice in addition to its default language.
     */
    @JvmName("tkojheytshxpkqva")
    public suspend fun additionalLanguageCodes(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.additionalLanguageCodes = mapped
    }

    /**
     * @param values Additional codes for languages available for the specified voice in addition to its default language.
     */
    @JvmName("boxxixvtgqjijpee")
    public suspend fun additionalLanguageCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.additionalLanguageCodes = mapped
    }

    /**
     * @param value Gender of the voice.
     */
    @JvmName("vvmvnvxmpjcasgln")
    public suspend fun gender(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gender = mapped
    }

    /**
     * @param value Amazon Polly assigned voice ID.
     */
    @JvmName("vprpkekkhmyopjwt")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
     */
    @JvmName("wrldihsijrvccvkd")
    public suspend fun languageCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.languageCode = mapped
    }

    /**
     * @param value Human readable name of the language in English.
     */
    @JvmName("bfcgbpskjjcyoeru")
    public suspend fun languageName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.languageName = mapped
    }

    /**
     * @param value Name of the voice.
     */
    @JvmName("nncwmqhdflbrhxxy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Specifies which engines are supported by a given voice.
     */
    @JvmName("ufcvkxilnnpujnvk")
    public suspend fun supportedEngines(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedEngines = mapped
    }

    /**
     * @param values Specifies which engines are supported by a given voice.
     */
    @JvmName("opmihpebqscabapq")
    public suspend fun supportedEngines(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.supportedEngines = mapped
    }

    internal fun build(): GetVoicesVoice = GetVoicesVoice(
        additionalLanguageCodes = additionalLanguageCodes ?: throw
            PulumiNullFieldException("additionalLanguageCodes"),
        gender = gender ?: throw PulumiNullFieldException("gender"),
        id = id ?: throw PulumiNullFieldException("id"),
        languageCode = languageCode ?: throw PulumiNullFieldException("languageCode"),
        languageName = languageName ?: throw PulumiNullFieldException("languageName"),
        name = name ?: throw PulumiNullFieldException("name"),
        supportedEngines = supportedEngines ?: throw PulumiNullFieldException("supportedEngines"),
    )
}
