@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.polly.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getVoices.
 * @property engine
 * @property id Amazon Polly assigned voice ID.
 * @property includeAdditionalLanguageCodes
 * @property languageCode Language code of the voice.
 * @property voices List of voices with their properties. See `voices` Attribute Reference below.
 */
public data class GetVoicesResult(
    public val engine: String? = null,
    public val id: String,
    public val includeAdditionalLanguageCodes: Boolean? = null,
    public val languageCode: String? = null,
    public val voices: List<GetVoicesVoice>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.polly.outputs.GetVoicesResult): GetVoicesResult =
            GetVoicesResult(
                engine = javaType.engine().map({ args0 -> args0 }).orElse(null),
                id = javaType.id(),
                includeAdditionalLanguageCodes = javaType.includeAdditionalLanguageCodes().map({ args0 ->
                    args0
                }).orElse(null),
                languageCode = javaType.languageCode().map({ args0 -> args0 }).orElse(null),
                voices = javaType.voices().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.polly.kotlin.outputs.GetVoicesVoice.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
