@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.polly.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property additionalLanguageCodes Additional codes for languages available for the specified voice in addition to its default language.
 * @property gender Gender of the voice.
 * @property id Amazon Polly assigned voice ID.
 * @property languageCode Language identification tag for filtering the list of voices returned. If not specified, all available voices are returned.
 * @property languageName Human readable name of the language in English.
 * @property name Name of the voice.
 * @property supportedEngines Specifies which engines are supported by a given voice.
 */
public data class GetVoicesVoice(
    public val additionalLanguageCodes: List<String>,
    public val gender: String,
    public val id: String,
    public val languageCode: String,
    public val languageName: String,
    public val name: String,
    public val supportedEngines: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.polly.outputs.GetVoicesVoice): GetVoicesVoice =
            GetVoicesVoice(
                additionalLanguageCodes = javaType.additionalLanguageCodes().map({ args0 -> args0 }),
                gender = javaType.gender(),
                id = javaType.id(),
                languageCode = javaType.languageCode(),
                languageName = javaType.languageName(),
                name = javaType.name(),
                supportedEngines = javaType.supportedEngines().map({ args0 -> args0 }),
            )
    }
}
