@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.pricing.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getProduct.
 * @property filters
 * @property id The provider-assigned unique ID for this managed resource.
 * @property result Set to the product returned from the API.
 * @property serviceCode
 */
public data class GetProductResult(
    public val filters: List<GetProductFilter>,
    public val id: String,
    public val result: String,
    public val serviceCode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.pricing.outputs.GetProductResult): GetProductResult = GetProductResult(
            filters = javaType.filters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.pricing.kotlin.outputs.GetProductFilter.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            result = javaType.result(),
            serviceCode = javaType.serviceCode(),
        )
    }
}
