@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Ledger].
 */
@PulumiTagMarker
public class LedgerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: LedgerArgs = LedgerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend LedgerArgsBuilder.() -> Unit) {
        val builder = LedgerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Ledger {
        val builtJavaResource = com.pulumi.aws.qldb.Ledger(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Ledger(builtJavaResource)
    }
}

/**
 * Provides an AWS Quantum Ledger Database (QLDB) resource
 * > **NOTE:** Deletion protection is enabled by default. To successfully delete this resource via this provider, `deletion_protection = false` must be applied before attempting deletion.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const sample_ledger = new aws.qldb.Ledger("sample-ledger", {
 *     name: "sample-ledger",
 *     permissionsMode: "STANDARD",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * sample_ledger = aws.qldb.Ledger("sample-ledger",
 *     name="sample-ledger",
 *     permissions_mode="STANDARD")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var sample_ledger = new Aws.Qldb.Ledger("sample-ledger", new()
 *     {
 *         Name = "sample-ledger",
 *         PermissionsMode = "STANDARD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/qldb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := qldb.NewLedger(ctx, "sample-ledger", &qldb.LedgerArgs{
 * 			Name:            pulumi.String("sample-ledger"),
 * 			PermissionsMode: pulumi.String("STANDARD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.qldb.Ledger;
 * import com.pulumi.aws.qldb.LedgerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var sample_ledger = new Ledger("sample-ledger", LedgerArgs.builder()
 *             .name("sample-ledger")
 *             .permissionsMode("STANDARD")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   sample-ledger:
 *     type: aws:qldb:Ledger
 *     properties:
 *       name: sample-ledger
 *       permissionsMode: STANDARD
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QLDB Ledgers using the `name`. For example:
 * ```sh
 * $ pulumi import aws:qldb/ledger:Ledger sample-ledger sample-ledger
 * ```
 */
public class Ledger internal constructor(
    override val javaResource: com.pulumi.aws.qldb.Ledger,
) : KotlinCustomResource(javaResource, LedgerMapper) {
    /**
     * The ARN of the QLDB Ledger
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The deletion protection for the QLDB Ledger instance. By default it is `true`. To delete this resource via the provider, this value must be configured to `false` and applied first before attempting deletion.
     */
    public val deletionProtection: Output<Boolean>?
        get() = javaResource.deletionProtection().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The key in AWS Key Management Service (AWS KMS) to use for encryption of data at rest in the ledger. For more information, see the [AWS documentation](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html). Valid values are `"AWS_OWNED_KMS_KEY"` to use an AWS KMS key that is owned and managed by AWS on your behalf, or the ARN of a valid symmetric customer managed KMS key.
     */
    public val kmsKey: Output<String>
        get() = javaResource.kmsKey().applyValue({ args0 -> args0 })

    /**
     * The friendly name for the QLDB Ledger instance. By default generated by the provider.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The permissions mode for the QLDB ledger instance. Specify either `ALLOW_ALL` or `STANDARD`.
     */
    public val permissionsMode: Output<String>
        get() = javaResource.permissionsMode().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object LedgerMapper : ResourceMapper<Ledger> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.qldb.Ledger::class == javaResource::class

    override fun map(javaResource: Resource): Ledger = Ledger(
        javaResource as
            com.pulumi.aws.qldb.Ledger,
    )
}

/**
 * @see [Ledger].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Ledger].
 */
public suspend fun ledger(name: String, block: suspend LedgerResourceBuilder.() -> Unit): Ledger {
    val builder = LedgerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Ledger].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ledger(name: String): Ledger {
    val builder = LedgerResourceBuilder()
    builder.name(name)
    return builder.build()
}
