@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin

import com.pulumi.aws.qldb.StreamArgs.builder
import com.pulumi.aws.qldb.kotlin.inputs.StreamKinesisConfigurationArgs
import com.pulumi.aws.qldb.kotlin.inputs.StreamKinesisConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AWS Quantum Ledger Database (QLDB) Stream resource
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.qldb.Stream("example", {
 *     ledgerName: "existing-ledger-name",
 *     streamName: "sample-ledger-stream",
 *     roleArn: "sample-role-arn",
 *     inclusiveStartTime: "2021-01-01T00:00:00Z",
 *     kinesisConfiguration: {
 *         aggregationEnabled: false,
 *         streamArn: "arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream",
 *     },
 *     tags: {
 *         example: "tag",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.qldb.Stream("example",
 *     ledger_name="existing-ledger-name",
 *     stream_name="sample-ledger-stream",
 *     role_arn="sample-role-arn",
 *     inclusive_start_time="2021-01-01T00:00:00Z",
 *     kinesis_configuration={
 *         "aggregation_enabled": False,
 *         "stream_arn": "arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream",
 *     },
 *     tags={
 *         "example": "tag",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Qldb.Stream("example", new()
 *     {
 *         LedgerName = "existing-ledger-name",
 *         StreamName = "sample-ledger-stream",
 *         RoleArn = "sample-role-arn",
 *         InclusiveStartTime = "2021-01-01T00:00:00Z",
 *         KinesisConfiguration = new Aws.Qldb.Inputs.StreamKinesisConfigurationArgs
 *         {
 *             AggregationEnabled = false,
 *             StreamArn = "arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream",
 *         },
 *         Tags =
 *         {
 *             { "example", "tag" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/qldb"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := qldb.NewStream(ctx, "example", &qldb.StreamArgs{
 * 			LedgerName:         pulumi.String("existing-ledger-name"),
 * 			StreamName:         pulumi.String("sample-ledger-stream"),
 * 			RoleArn:            pulumi.String("sample-role-arn"),
 * 			InclusiveStartTime: pulumi.String("2021-01-01T00:00:00Z"),
 * 			KinesisConfiguration: &qldb.StreamKinesisConfigurationArgs{
 * 				AggregationEnabled: pulumi.Bool(false),
 * 				StreamArn:          pulumi.String("arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"example": pulumi.String("tag"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.qldb.Stream;
 * import com.pulumi.aws.qldb.StreamArgs;
 * import com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stream("example", StreamArgs.builder()
 *             .ledgerName("existing-ledger-name")
 *             .streamName("sample-ledger-stream")
 *             .roleArn("sample-role-arn")
 *             .inclusiveStartTime("2021-01-01T00:00:00Z")
 *             .kinesisConfiguration(StreamKinesisConfigurationArgs.builder()
 *                 .aggregationEnabled(false)
 *                 .streamArn("arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream")
 *                 .build())
 *             .tags(Map.of("example", "tag"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:qldb:Stream
 *     properties:
 *       ledgerName: existing-ledger-name
 *       streamName: sample-ledger-stream
 *       roleArn: sample-role-arn
 *       inclusiveStartTime: 2021-01-01T00:00:00Z
 *       kinesisConfiguration:
 *         aggregationEnabled: false
 *         streamArn: arn:aws:kinesis:us-east-1:xxxxxxxxxxxx:stream/example-kinesis-stream
 *       tags:
 *         example: tag
 * ```
 * <!--End PulumiCodeChooser -->
 * @property exclusiveEndTime The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it. It must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.
 * @property inclusiveStartTime The inclusive start date and time from which to start streaming journal data. This parameter must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.  This cannot be in the future and must be before `exclusive_end_time`.  If you provide a value that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
 * @property kinesisConfiguration The configuration settings of the Kinesis Data Streams destination for your stream request. Documented below.
 * @property ledgerName The name of the QLDB ledger.
 * @property roleArn The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
 * @property streamName The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.  Your stream name must be unique among other active streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in the [Amazon QLDB Developer Guide](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming).
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class StreamArgs(
    public val exclusiveEndTime: Output<String>? = null,
    public val inclusiveStartTime: Output<String>? = null,
    public val kinesisConfiguration: Output<StreamKinesisConfigurationArgs>? = null,
    public val ledgerName: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val streamName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.qldb.StreamArgs> {
    override fun toJava(): com.pulumi.aws.qldb.StreamArgs = com.pulumi.aws.qldb.StreamArgs.builder()
        .exclusiveEndTime(exclusiveEndTime?.applyValue({ args0 -> args0 }))
        .inclusiveStartTime(inclusiveStartTime?.applyValue({ args0 -> args0 }))
        .kinesisConfiguration(
            kinesisConfiguration?.applyValue({ args0 ->
                args0.let({ args0 ->
                    args0.toJava()
                })
            }),
        )
        .ledgerName(ledgerName?.applyValue({ args0 -> args0 }))
        .roleArn(roleArn?.applyValue({ args0 -> args0 }))
        .streamName(streamName?.applyValue({ args0 -> args0 }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [StreamArgs].
 */
@PulumiTagMarker
public class StreamArgsBuilder internal constructor() {
    private var exclusiveEndTime: Output<String>? = null

    private var inclusiveStartTime: Output<String>? = null

    private var kinesisConfiguration: Output<StreamKinesisConfigurationArgs>? = null

    private var ledgerName: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var streamName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it. It must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.
     */
    @JvmName("vnikeaqoovmbblmb")
    public suspend fun exclusiveEndTime(`value`: Output<String>) {
        this.exclusiveEndTime = value
    }

    /**
     * @param value The inclusive start date and time from which to start streaming journal data. This parameter must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.  This cannot be in the future and must be before `exclusive_end_time`.  If you provide a value that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
     */
    @JvmName("dnadmbqrexpfyrio")
    public suspend fun inclusiveStartTime(`value`: Output<String>) {
        this.inclusiveStartTime = value
    }

    /**
     * @param value The configuration settings of the Kinesis Data Streams destination for your stream request. Documented below.
     */
    @JvmName("uohvecwggrkajcps")
    public suspend fun kinesisConfiguration(`value`: Output<StreamKinesisConfigurationArgs>) {
        this.kinesisConfiguration = value
    }

    /**
     * @param value The name of the QLDB ledger.
     */
    @JvmName("iucudyflitsokoat")
    public suspend fun ledgerName(`value`: Output<String>) {
        this.ledgerName = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     */
    @JvmName("esidggwrpfyusrcy")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.  Your stream name must be unique among other active streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in the [Amazon QLDB Developer Guide](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming).
     */
    @JvmName("beokyclqdmgqelkl")
    public suspend fun streamName(`value`: Output<String>) {
        this.streamName = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("usumxylcfqaibtuk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it. It must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.
     */
    @JvmName("qcqjvxphibdiswvu")
    public suspend fun exclusiveEndTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusiveEndTime = mapped
    }

    /**
     * @param value The inclusive start date and time from which to start streaming journal data. This parameter must be in ISO 8601 date and time format and in Universal Coordinated Time (UTC). For example: `"2019-06-13T21:36:34Z"`.  This cannot be in the future and must be before `exclusive_end_time`.  If you provide a value that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
     */
    @JvmName("nwdoyxukqwuhybiq")
    public suspend fun inclusiveStartTime(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inclusiveStartTime = mapped
    }

    /**
     * @param value The configuration settings of the Kinesis Data Streams destination for your stream request. Documented below.
     */
    @JvmName("qrhlmxbooguwynkf")
    public suspend fun kinesisConfiguration(`value`: StreamKinesisConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kinesisConfiguration = mapped
    }

    /**
     * @param argument The configuration settings of the Kinesis Data Streams destination for your stream request. Documented below.
     */
    @JvmName("ekhbwdxcksefswof")
    public suspend fun kinesisConfiguration(argument: suspend StreamKinesisConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = StreamKinesisConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kinesisConfiguration = mapped
    }

    /**
     * @param value The name of the QLDB ledger.
     */
    @JvmName("owtracyxyyahjglk")
    public suspend fun ledgerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ledgerName = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     */
    @JvmName("pawongobgicfgmpc")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.  Your stream name must be unique among other active streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in the [Amazon QLDB Developer Guide](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming).
     */
    @JvmName("mgudbdemrqpexemw")
    public suspend fun streamName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamName = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jfqmfpyuxtyocysp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bathurfsyovrfodc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StreamArgs = StreamArgs(
        exclusiveEndTime = exclusiveEndTime,
        inclusiveStartTime = inclusiveStartTime,
        kinesisConfiguration = kinesisConfiguration,
        ledgerName = ledgerName,
        roleArn = roleArn,
        streamName = streamName,
        tags = tags,
    )
}
