@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin.inputs

import com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property aggregationEnabled Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call. Default: `true`.
 * @property streamArn The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
 */
public data class StreamKinesisConfigurationArgs(
    public val aggregationEnabled: Output<Boolean>? = null,
    public val streamArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs =
        com.pulumi.aws.qldb.inputs.StreamKinesisConfigurationArgs.builder()
            .aggregationEnabled(aggregationEnabled?.applyValue({ args0 -> args0 }))
            .streamArn(streamArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StreamKinesisConfigurationArgs].
 */
@PulumiTagMarker
public class StreamKinesisConfigurationArgsBuilder internal constructor() {
    private var aggregationEnabled: Output<Boolean>? = null

    private var streamArn: Output<String>? = null

    /**
     * @param value Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call. Default: `true`.
     */
    @JvmName("xomuqfkkjrwmwcij")
    public suspend fun aggregationEnabled(`value`: Output<Boolean>) {
        this.aggregationEnabled = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     */
    @JvmName("awwdaqomophbaobt")
    public suspend fun streamArn(`value`: Output<String>) {
        this.streamArn = value
    }

    /**
     * @param value Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call. Default: `true`.
     */
    @JvmName("tpnvghqiikpnjjxp")
    public suspend fun aggregationEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aggregationEnabled = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     */
    @JvmName("pahwyuiihmfyggtf")
    public suspend fun streamArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.streamArn = mapped
    }

    internal fun build(): StreamKinesisConfigurationArgs = StreamKinesisConfigurationArgs(
        aggregationEnabled = aggregationEnabled,
        streamArn = streamArn ?: throw PulumiNullFieldException("streamArn"),
    )
}
