@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.qldb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getLedger.
 * @property arn
 * @property deletionProtection
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKey
 * @property name
 * @property permissionsMode
 * @property tags
 */
public data class GetLedgerResult(
    public val arn: String,
    public val deletionProtection: Boolean,
    public val id: String,
    public val kmsKey: String,
    public val name: String,
    public val permissionsMode: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.qldb.outputs.GetLedgerResult): GetLedgerResult =
            GetLedgerResult(
                arn = javaType.arn(),
                deletionProtection = javaType.deletionProtection(),
                id = javaType.id(),
                kmsKey = javaType.kmsKey(),
                name = javaType.name(),
                permissionsMode = javaType.permissionsMode(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
