@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisParameters
import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisPermission
import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisSourceEntity
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisParameters.Companion.toKotlin as analysisParametersToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisPermission.Companion.toKotlin as analysisPermissionToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.AnalysisSourceEntity.Companion.toKotlin as analysisSourceEntityToKotlin

/**
 * Builder for [Analysis].
 */
@PulumiTagMarker
public class AnalysisResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AnalysisArgs = AnalysisArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AnalysisArgsBuilder.() -> Unit) {
        val builder = AnalysisArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Analysis {
        val builtJavaResource = com.pulumi.aws.quicksight.Analysis(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Analysis(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Analysis.
 * ## Example Usage
 * ### From Source Template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Analysis("example", {
 *     analysisId: "example-id",
 *     name: "example-name",
 *     sourceEntity: {
 *         sourceTemplate: {
 *             arn: source.arn,
 *             dataSetReferences: [{
 *                 dataSetArn: dataset.arn,
 *                 dataSetPlaceholder: "1",
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Analysis("example",
 *     analysis_id="example-id",
 *     name="example-name",
 *     source_entity={
 *         "source_template": {
 *             "arn": source["arn"],
 *             "data_set_references": [{
 *                 "data_set_arn": dataset["arn"],
 *                 "data_set_placeholder": "1",
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Analysis("example", new()
 *     {
 *         AnalysisId = "example-id",
 *         Name = "example-name",
 *         SourceEntity = new Aws.Quicksight.Inputs.AnalysisSourceEntityArgs
 *         {
 *             SourceTemplate = new Aws.Quicksight.Inputs.AnalysisSourceEntitySourceTemplateArgs
 *             {
 *                 Arn = source.Arn,
 *                 DataSetReferences = new[]
 *                 {
 *                     new Aws.Quicksight.Inputs.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs
 *                     {
 *                         DataSetArn = dataset.Arn,
 *                         DataSetPlaceholder = "1",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewAnalysis(ctx, "example", &quicksight.AnalysisArgs{
 * 			AnalysisId: pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			SourceEntity: &quicksight.AnalysisSourceEntityArgs{
 * 				SourceTemplate: &quicksight.AnalysisSourceEntitySourceTemplateArgs{
 * 					Arn: pulumi.Any(source.Arn),
 * 					DataSetReferences: quicksight.AnalysisSourceEntitySourceTemplateDataSetReferenceArray{
 * 						&quicksight.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs{
 * 							DataSetArn:         pulumi.Any(dataset.Arn),
 * 							DataSetPlaceholder: pulumi.String("1"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Analysis;
 * import com.pulumi.aws.quicksight.AnalysisArgs;
 * import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Analysis("example", AnalysisArgs.builder()
 *             .analysisId("example-id")
 *             .name("example-name")
 *             .sourceEntity(AnalysisSourceEntityArgs.builder()
 *                 .sourceTemplate(AnalysisSourceEntitySourceTemplateArgs.builder()
 *                     .arn(source.arn())
 *                     .dataSetReferences(AnalysisSourceEntitySourceTemplateDataSetReferenceArgs.builder()
 *                         .dataSetArn(dataset.arn())
 *                         .dataSetPlaceholder("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Analysis
 *     properties:
 *       analysisId: example-id
 *       name: example-name
 *       sourceEntity:
 *         sourceTemplate:
 *           arn: ${source.arn}
 *           dataSetReferences:
 *             - dataSetArn: ${dataset.arn}
 *               dataSetPlaceholder: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Definition
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Analysis
 *     properties:
 *       analysisId: example-id
 *       name: example-name
 *       definition:
 *         dataSetIdentifiersDeclarations:
 *           - dataSetArn: ${dataset.arn}
 *             identifier: '1'
 *         sheets:
 *           - title: Example
 *             sheetId: Example1
 *             visuals:
 *               - lineChartVisual:
 *                   visualId: LineChart
 *                   title:
 *                     formatText:
 *                       plainText: Line Chart Example
 *                   chartConfiguration:
 *                     fieldWells:
 *                       lineChartAggregatedFieldWells:
 *                         categories:
 *                           - categoricalDimensionField:
 *                               fieldId: '1'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                         values:
 *                           - categoricalMeasureField:
 *                               fieldId: '2'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                               aggregationFunction: COUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Analysis using the AWS account ID and analysis ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/analysis:Analysis example 123456789012,example-id
 * ```
 */
public class Analysis internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Analysis,
) : KotlinCustomResource(javaResource, AnalysisMapper) {
    /**
     * Identifier for the analysis.
     */
    public val analysisId: Output<String>
        get() = javaResource.analysisId().applyValue({ args0 -> args0 })

    /**
     * ARN of the analysis.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The time that the analysis was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    public val lastPublishedTime: Output<String>
        get() = javaResource.lastPublishedTime().applyValue({ args0 -> args0 })

    /**
     * The time that the analysis was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Display name for the analysis.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters for the creation of the analysis, which you want to use to override the default settings. An analysis can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    public val parameters: Output<AnalysisParameters>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.let({ args0 ->
                analysisParametersToKotlin(args0)
            })
        })

    /**
     * A set of resource permissions on the analysis. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<AnalysisPermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> analysisPermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A value that specifies the number of days that Amazon QuickSight waits before it deletes the analysis. Use `0` to force deletion without recovery. Minimum value of `7`. Maximum value of `30`. Default to `30`.
     */
    public val recoveryWindowInDays: Output<Int>?
        get() = javaResource.recoveryWindowInDays().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The entity that you are using as a source when you create the analysis (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    public val sourceEntity: Output<AnalysisSourceEntity>?
        get() = javaResource.sourceEntity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    analysisSourceEntityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The analysis creation status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this analysis. The theme ARN must exist in the same AWS account where you create the analysis.
     */
    public val themeArn: Output<String>?
        get() = javaResource.themeArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object AnalysisMapper : ResourceMapper<Analysis> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Analysis::class == javaResource::class

    override fun map(javaResource: Resource): Analysis = Analysis(
        javaResource as
            com.pulumi.aws.quicksight.Analysis,
    )
}

/**
 * @see [Analysis].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Analysis].
 */
public suspend fun analysis(name: String, block: suspend AnalysisResourceBuilder.() -> Unit): Analysis {
    val builder = AnalysisResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Analysis].
 * @param name The _unique_ name of the resulting resource.
 */
public fun analysis(name: String): Analysis {
    val builder = AnalysisResourceBuilder()
    builder.name(name)
    return builder.build()
}
