@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptions
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardParameters
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardPermission
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardSourceEntity
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardDashboardPublishOptions.Companion.toKotlin as dashboardDashboardPublishOptionsToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardParameters.Companion.toKotlin as dashboardParametersToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardPermission.Companion.toKotlin as dashboardPermissionToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DashboardSourceEntity.Companion.toKotlin as dashboardSourceEntityToKotlin

/**
 * Builder for [Dashboard].
 */
@PulumiTagMarker
public class DashboardResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DashboardArgs = DashboardArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DashboardArgsBuilder.() -> Unit) {
        val builder = DashboardArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Dashboard {
        val builtJavaResource = com.pulumi.aws.quicksight.Dashboard(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Dashboard(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Dashboard.
 * ## Example Usage
 * ### From Source Template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Dashboard("example", {
 *     dashboardId: "example-id",
 *     name: "example-name",
 *     versionDescription: "version",
 *     sourceEntity: {
 *         sourceTemplate: {
 *             arn: source.arn,
 *             dataSetReferences: [{
 *                 dataSetArn: dataset.arn,
 *                 dataSetPlaceholder: "1",
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Dashboard("example",
 *     dashboard_id="example-id",
 *     name="example-name",
 *     version_description="version",
 *     source_entity={
 *         "source_template": {
 *             "arn": source["arn"],
 *             "data_set_references": [{
 *                 "data_set_arn": dataset["arn"],
 *                 "data_set_placeholder": "1",
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Dashboard("example", new()
 *     {
 *         DashboardId = "example-id",
 *         Name = "example-name",
 *         VersionDescription = "version",
 *         SourceEntity = new Aws.Quicksight.Inputs.DashboardSourceEntityArgs
 *         {
 *             SourceTemplate = new Aws.Quicksight.Inputs.DashboardSourceEntitySourceTemplateArgs
 *             {
 *                 Arn = source.Arn,
 *                 DataSetReferences = new[]
 *                 {
 *                     new Aws.Quicksight.Inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs
 *                     {
 *                         DataSetArn = dataset.Arn,
 *                         DataSetPlaceholder = "1",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDashboard(ctx, "example", &quicksight.DashboardArgs{
 * 			DashboardId:        pulumi.String("example-id"),
 * 			Name:               pulumi.String("example-name"),
 * 			VersionDescription: pulumi.String("version"),
 * 			SourceEntity: &quicksight.DashboardSourceEntityArgs{
 * 				SourceTemplate: &quicksight.DashboardSourceEntitySourceTemplateArgs{
 * 					Arn: pulumi.Any(source.Arn),
 * 					DataSetReferences: quicksight.DashboardSourceEntitySourceTemplateDataSetReferenceArray{
 * 						&quicksight.DashboardSourceEntitySourceTemplateDataSetReferenceArgs{
 * 							DataSetArn:         pulumi.Any(dataset.Arn),
 * 							DataSetPlaceholder: pulumi.String("1"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Dashboard;
 * import com.pulumi.aws.quicksight.DashboardArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Dashboard("example", DashboardArgs.builder()
 *             .dashboardId("example-id")
 *             .name("example-name")
 *             .versionDescription("version")
 *             .sourceEntity(DashboardSourceEntityArgs.builder()
 *                 .sourceTemplate(DashboardSourceEntitySourceTemplateArgs.builder()
 *                     .arn(source.arn())
 *                     .dataSetReferences(DashboardSourceEntitySourceTemplateDataSetReferenceArgs.builder()
 *                         .dataSetArn(dataset.arn())
 *                         .dataSetPlaceholder("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Dashboard
 *     properties:
 *       dashboardId: example-id
 *       name: example-name
 *       versionDescription: version
 *       sourceEntity:
 *         sourceTemplate:
 *           arn: ${source.arn}
 *           dataSetReferences:
 *             - dataSetArn: ${dataset.arn}
 *               dataSetPlaceholder: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Definition
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Dashboard
 *     properties:
 *       dashboardId: example-id
 *       name: example-name
 *       versionDescription: version
 *       definition:
 *         dataSetIdentifiersDeclarations:
 *           - dataSetArn: ${dataset.arn}
 *             identifier: '1'
 *         sheets:
 *           - title: Example
 *             sheetId: Example1
 *             visuals:
 *               - lineChartVisual:
 *                   visualId: LineChart
 *                   title:
 *                     formatText:
 *                       plainText: Line Chart Example
 *                   chartConfiguration:
 *                     fieldWells:
 *                       lineChartAggregatedFieldWells:
 *                         categories:
 *                           - categoricalDimensionField:
 *                               fieldId: '1'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                         values:
 *                           - categoricalMeasureField:
 *                               fieldId: '2'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                               aggregationFunction: COUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Dashboard using the AWS account ID and dashboard ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/dashboard:Dashboard example 123456789012,example-id
 * ```
 */
public class Dashboard internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Dashboard,
) : KotlinCustomResource(javaResource, DashboardMapper) {
    /**
     * ARN of the dashboard.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The time that the dashboard was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Identifier for the dashboard.
     */
    public val dashboardId: Output<String>
        get() = javaResource.dashboardId().applyValue({ args0 -> args0 })

    /**
     * Options for publishing the dashboard. See dashboard_publish_options.
     */
    public val dashboardPublishOptions: Output<DashboardDashboardPublishOptions>
        get() = javaResource.dashboardPublishOptions().applyValue({ args0 ->
            args0.let({ args0 ->
                dashboardDashboardPublishOptionsToKotlin(args0)
            })
        })

    public val lastPublishedTime: Output<String>
        get() = javaResource.lastPublishedTime().applyValue({ args0 -> args0 })

    /**
     * The time that the dashboard was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Display name for the dashboard.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    public val parameters: Output<DashboardParameters>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.let({ args0 ->
                dashboardParametersToKotlin(args0)
            })
        })

    /**
     * A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<DashboardPermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dashboardPermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    public val sourceEntity: Output<DashboardSourceEntity>?
        get() = javaResource.sourceEntity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dashboardSourceEntityToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Amazon Resource Name (ARN) of a template that was used to create this dashboard.
     */
    public val sourceEntityArn: Output<String>
        get() = javaResource.sourceEntityArn().applyValue({ args0 -> args0 })

    /**
     * The dashboard creation status.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    public val themeArn: Output<String>?
        get() = javaResource.themeArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A description of the current dashboard version being created/updated.
     * The following arguments are optional:
     */
    public val versionDescription: Output<String>
        get() = javaResource.versionDescription().applyValue({ args0 -> args0 })

    /**
     * The version number of the dashboard version.
     */
    public val versionNumber: Output<Int>
        get() = javaResource.versionNumber().applyValue({ args0 -> args0 })
}

public object DashboardMapper : ResourceMapper<Dashboard> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Dashboard::class == javaResource::class

    override fun map(javaResource: Resource): Dashboard = Dashboard(
        javaResource as
            com.pulumi.aws.quicksight.Dashboard,
    )
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dashboard].
 */
public suspend fun dashboard(name: String, block: suspend DashboardResourceBuilder.() -> Unit): Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dashboard].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dashboard(name: String): Dashboard {
    val builder = DashboardResourceBuilder()
    builder.name(name)
    return builder.build()
}
