@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.DashboardArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardDashboardPublishOptionsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardDashboardPublishOptionsArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardParametersArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardParametersArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardPermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardSourceEntityArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DashboardSourceEntityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Dashboard.
 * ## Example Usage
 * ### From Source Template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Dashboard("example", {
 *     dashboardId: "example-id",
 *     name: "example-name",
 *     versionDescription: "version",
 *     sourceEntity: {
 *         sourceTemplate: {
 *             arn: source.arn,
 *             dataSetReferences: [{
 *                 dataSetArn: dataset.arn,
 *                 dataSetPlaceholder: "1",
 *             }],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Dashboard("example",
 *     dashboard_id="example-id",
 *     name="example-name",
 *     version_description="version",
 *     source_entity={
 *         "source_template": {
 *             "arn": source["arn"],
 *             "data_set_references": [{
 *                 "data_set_arn": dataset["arn"],
 *                 "data_set_placeholder": "1",
 *             }],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Dashboard("example", new()
 *     {
 *         DashboardId = "example-id",
 *         Name = "example-name",
 *         VersionDescription = "version",
 *         SourceEntity = new Aws.Quicksight.Inputs.DashboardSourceEntityArgs
 *         {
 *             SourceTemplate = new Aws.Quicksight.Inputs.DashboardSourceEntitySourceTemplateArgs
 *             {
 *                 Arn = source.Arn,
 *                 DataSetReferences = new[]
 *                 {
 *                     new Aws.Quicksight.Inputs.DashboardSourceEntitySourceTemplateDataSetReferenceArgs
 *                     {
 *                         DataSetArn = dataset.Arn,
 *                         DataSetPlaceholder = "1",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDashboard(ctx, "example", &quicksight.DashboardArgs{
 * 			DashboardId:        pulumi.String("example-id"),
 * 			Name:               pulumi.String("example-name"),
 * 			VersionDescription: pulumi.String("version"),
 * 			SourceEntity: &quicksight.DashboardSourceEntityArgs{
 * 				SourceTemplate: &quicksight.DashboardSourceEntitySourceTemplateArgs{
 * 					Arn: pulumi.Any(source.Arn),
 * 					DataSetReferences: quicksight.DashboardSourceEntitySourceTemplateDataSetReferenceArray{
 * 						&quicksight.DashboardSourceEntitySourceTemplateDataSetReferenceArgs{
 * 							DataSetArn:         pulumi.Any(dataset.Arn),
 * 							DataSetPlaceholder: pulumi.String("1"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Dashboard;
 * import com.pulumi.aws.quicksight.DashboardArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.DashboardSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Dashboard("example", DashboardArgs.builder()
 *             .dashboardId("example-id")
 *             .name("example-name")
 *             .versionDescription("version")
 *             .sourceEntity(DashboardSourceEntityArgs.builder()
 *                 .sourceTemplate(DashboardSourceEntitySourceTemplateArgs.builder()
 *                     .arn(source.arn())
 *                     .dataSetReferences(DashboardSourceEntitySourceTemplateDataSetReferenceArgs.builder()
 *                         .dataSetArn(dataset.arn())
 *                         .dataSetPlaceholder("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Dashboard
 *     properties:
 *       dashboardId: example-id
 *       name: example-name
 *       versionDescription: version
 *       sourceEntity:
 *         sourceTemplate:
 *           arn: ${source.arn}
 *           dataSetReferences:
 *             - dataSetArn: ${dataset.arn}
 *               dataSetPlaceholder: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Definition
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Dashboard
 *     properties:
 *       dashboardId: example-id
 *       name: example-name
 *       versionDescription: version
 *       definition:
 *         dataSetIdentifiersDeclarations:
 *           - dataSetArn: ${dataset.arn}
 *             identifier: '1'
 *         sheets:
 *           - title: Example
 *             sheetId: Example1
 *             visuals:
 *               - lineChartVisual:
 *                   visualId: LineChart
 *                   title:
 *                     formatText:
 *                       plainText: Line Chart Example
 *                   chartConfiguration:
 *                     fieldWells:
 *                       lineChartAggregatedFieldWells:
 *                         categories:
 *                           - categoricalDimensionField:
 *                               fieldId: '1'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                         values:
 *                           - categoricalMeasureField:
 *                               fieldId: '2'
 *                               column:
 *                                 dataSetIdentifier: '1'
 *                                 columnName: Column1
 *                               aggregationFunction: COUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Dashboard using the AWS account ID and dashboard ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/dashboard:Dashboard example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dashboardId Identifier for the dashboard.
 * @property dashboardPublishOptions Options for publishing the dashboard. See dashboard_publish_options.
 * @property name Display name for the dashboard.
 * @property parameters The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
 * @property permissions A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
 * @property sourceEntity The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property themeArn The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
 * @property versionDescription A description of the current dashboard version being created/updated.
 * The following arguments are optional:
 */
public data class DashboardArgs(
    public val awsAccountId: Output<String>? = null,
    public val dashboardId: Output<String>? = null,
    public val dashboardPublishOptions: Output<DashboardDashboardPublishOptionsArgs>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<DashboardParametersArgs>? = null,
    public val permissions: Output<List<DashboardPermissionArgs>>? = null,
    public val sourceEntity: Output<DashboardSourceEntityArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val themeArn: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.DashboardArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.DashboardArgs =
        com.pulumi.aws.quicksight.DashboardArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dashboardId(dashboardId?.applyValue({ args0 -> args0 }))
            .dashboardPublishOptions(
                dashboardPublishOptions?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceEntity(sourceEntity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .themeArn(themeArn?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DashboardArgs].
 */
@PulumiTagMarker
public class DashboardArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dashboardId: Output<String>? = null

    private var dashboardPublishOptions: Output<DashboardDashboardPublishOptionsArgs>? = null

    private var name: Output<String>? = null

    private var parameters: Output<DashboardParametersArgs>? = null

    private var permissions: Output<List<DashboardPermissionArgs>>? = null

    private var sourceEntity: Output<DashboardSourceEntityArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var themeArn: Output<String>? = null

    private var versionDescription: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("pdetwryvagatmxew")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Identifier for the dashboard.
     */
    @JvmName("tpmedmddavyoswse")
    public suspend fun dashboardId(`value`: Output<String>) {
        this.dashboardId = value
    }

    /**
     * @param value Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("uwoufnrnkomqwvph")
    public suspend fun dashboardPublishOptions(`value`: Output<DashboardDashboardPublishOptionsArgs>) {
        this.dashboardPublishOptions = value
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("gmvcslsqvxbwiskr")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("kxqxsngeehomqjgq")
    public suspend fun parameters(`value`: Output<DashboardParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("lgqfroqhbsnwbimr")
    public suspend fun permissions(`value`: Output<List<DashboardPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("sklfemxijarahwfo")
    public suspend fun permissions(vararg values: Output<DashboardPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("buomxxfrbhfwnvgd")
    public suspend fun permissions(values: List<Output<DashboardPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("ffdnsyuyaxjhjstv")
    public suspend fun sourceEntity(`value`: Output<DashboardSourceEntityArgs>) {
        this.sourceEntity = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("hirknijjasciyteb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @JvmName("urbqwpbrgicgunnb")
    public suspend fun themeArn(`value`: Output<String>) {
        this.themeArn = value
    }

    /**
     * @param value A description of the current dashboard version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("hrgtopnxqifklhdm")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("jwkyasnuhsrrrbpx")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Identifier for the dashboard.
     */
    @JvmName("rduqtjukonihfbjv")
    public suspend fun dashboardId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardId = mapped
    }

    /**
     * @param value Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("jrjubgbdkxktkamk")
    public suspend fun dashboardPublishOptions(`value`: DashboardDashboardPublishOptionsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dashboardPublishOptions = mapped
    }

    /**
     * @param argument Options for publishing the dashboard. See dashboard_publish_options.
     */
    @JvmName("cgcwciwqlqahtcef")
    public suspend fun dashboardPublishOptions(argument: suspend DashboardDashboardPublishOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardDashboardPublishOptionsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dashboardPublishOptions = mapped
    }

    /**
     * @param value Display name for the dashboard.
     */
    @JvmName("uqmgoaexjxvehexo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("tcyuxufuujjcmhjr")
    public suspend fun parameters(`value`: DashboardParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters for the creation of the dashboard, which you want to use to override the default settings. A dashboard can have any type of parameters, and some parameters might accept multiple values. See parameters.
     */
    @JvmName("ekhwguihmmgukevu")
    public suspend fun parameters(argument: suspend DashboardParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("rehddlqqqnhbrdpk")
    public suspend fun permissions(`value`: List<DashboardPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("dkgdfthvsuqmmqnf")
    public suspend fun permissions(argument: List<suspend DashboardPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("cymjkespoxpotbyx")
    public suspend fun permissions(vararg argument: suspend DashboardPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("xxtnvgwxdsjyncgn")
    public suspend fun permissions(argument: suspend DashboardPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DashboardPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the dashboard. Maximum of 64 items. See permissions.
     */
    @JvmName("ggmbclbdbtlmffma")
    public suspend fun permissions(vararg values: DashboardPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("fnuvfvorfwafmndf")
    public suspend fun sourceEntity(`value`: DashboardSourceEntityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntity = mapped
    }

    /**
     * @param argument The entity that you are using as a source when you create the dashboard (template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("gaihpispwxjopdpj")
    public suspend fun sourceEntity(argument: suspend DashboardSourceEntityArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardSourceEntityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceEntity = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ranwcppnpjmrjyvs")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kndmhrdjsxoycddn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. The theme ARN must exist in the same AWS account where you create the dashboard.
     */
    @JvmName("pdhoepxvrybehvxf")
    public suspend fun themeArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.themeArn = mapped
    }

    /**
     * @param value A description of the current dashboard version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("bqxdepprqxikcfti")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    internal fun build(): DashboardArgs = DashboardArgs(
        awsAccountId = awsAccountId,
        dashboardId = dashboardId,
        dashboardPublishOptions = dashboardPublishOptions,
        name = name,
        parameters = parameters,
        permissions = permissions,
        sourceEntity = sourceEntity,
        tags = tags,
        themeArn = themeArn,
        versionDescription = versionDescription,
    )
}
