@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.DataSetColumnGroup
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetColumnLevelPermissionRule
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetDataSetUsageConfiguration
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetFieldFolder
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMap
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetOutputColumn
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetPermission
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMap
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRefreshProperties
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRowLevelPermissionDataSet
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRowLevelPermissionTagConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetColumnGroup.Companion.toKotlin as dataSetColumnGroupToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetColumnLevelPermissionRule.Companion.toKotlin as dataSetColumnLevelPermissionRuleToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetDataSetUsageConfiguration.Companion.toKotlin as dataSetDataSetUsageConfigurationToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetFieldFolder.Companion.toKotlin as dataSetFieldFolderToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetLogicalTableMap.Companion.toKotlin as dataSetLogicalTableMapToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetOutputColumn.Companion.toKotlin as dataSetOutputColumnToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetPermission.Companion.toKotlin as dataSetPermissionToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetPhysicalTableMap.Companion.toKotlin as dataSetPhysicalTableMapToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRefreshProperties.Companion.toKotlin as dataSetRefreshPropertiesToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRowLevelPermissionDataSet.Companion.toKotlin as dataSetRowLevelPermissionDataSetToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSetRowLevelPermissionTagConfiguration.Companion.toKotlin as dataSetRowLevelPermissionTagConfigurationToKotlin

/**
 * Builder for [DataSet].
 */
@PulumiTagMarker
public class DataSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSetArgs = DataSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSetArgsBuilder.() -> Unit) {
        val builder = DataSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataSet {
        val builtJavaResource = com.pulumi.aws.quicksight.DataSet(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSet(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Data Set.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.DataSet("example", {
 *     dataSetId: "example-id",
 *     name: "example-name",
 *     importMode: "SPICE",
 *     physicalTableMaps: [{
 *         physicalTableMapId: "example-id",
 *         s3Source: {
 *             dataSourceArn: exampleAwsQuicksightDataSource.arn,
 *             inputColumns: [{
 *                 name: "Column1",
 *                 type: "STRING",
 *             }],
 *             uploadSettings: {
 *                 format: "JSON",
 *             },
 *         },
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.DataSet("example",
 *     data_set_id="example-id",
 *     name="example-name",
 *     import_mode="SPICE",
 *     physical_table_maps=[{
 *         "physical_table_map_id": "example-id",
 *         "s3_source": {
 *             "data_source_arn": example_aws_quicksight_data_source["arn"],
 *             "input_columns": [{
 *                 "name": "Column1",
 *                 "type": "STRING",
 *             }],
 *             "upload_settings": {
 *                 "format": "JSON",
 *             },
 *         },
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.DataSet("example", new()
 *     {
 *         DataSetId = "example-id",
 *         Name = "example-name",
 *         ImportMode = "SPICE",
 *         PhysicalTableMaps = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPhysicalTableMapArgs
 *             {
 *                 PhysicalTableMapId = "example-id",
 *                 S3Source = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceArgs
 *                 {
 *                     DataSourceArn = exampleAwsQuicksightDataSource.Arn,
 *                     InputColumns = new[]
 *                     {
 *                         new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs
 *                         {
 *                             Name = "Column1",
 *                             Type = "STRING",
 *                         },
 *                     },
 *                     UploadSettings = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs
 *                     {
 *                         Format = "JSON",
 *                     },
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSet(ctx, "example", &quicksight.DataSetArgs{
 * 			DataSetId:  pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			ImportMode: pulumi.String("SPICE"),
 * 			PhysicalTableMaps: quicksight.DataSetPhysicalTableMapArray{
 * 				&quicksight.DataSetPhysicalTableMapArgs{
 * 					PhysicalTableMapId: pulumi.String("example-id"),
 * 					S3Source: &quicksight.DataSetPhysicalTableMapS3SourceArgs{
 * 						DataSourceArn: pulumi.Any(exampleAwsQuicksightDataSource.Arn),
 * 						InputColumns: quicksight.DataSetPhysicalTableMapS3SourceInputColumnArray{
 * 							&quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs{
 * 								Name: pulumi.String("Column1"),
 * 								Type: pulumi.String("STRING"),
 * 							},
 * 						},
 * 						UploadSettings: &quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs{
 * 							Format: pulumi.String("JSON"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .name("example-name")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(exampleAwsQuicksightDataSource.arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:DataSet
 *     properties:
 *       dataSetId: example-id
 *       name: example-name
 *       importMode: SPICE
 *       physicalTableMaps:
 *         - physicalTableMapId: example-id
 *           s3Source:
 *             dataSourceArn: ${exampleAwsQuicksightDataSource.arn}
 *             inputColumns:
 *               - name: Column1
 *                 type: STRING
 *             uploadSettings:
 *               format: JSON
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Column Level Permission Rules
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.DataSet("example", {
 *     dataSetId: "example-id",
 *     name: "example-name",
 *     importMode: "SPICE",
 *     physicalTableMaps: [{
 *         physicalTableMapId: "example-id",
 *         s3Source: {
 *             dataSourceArn: exampleAwsQuicksightDataSource.arn,
 *             inputColumns: [{
 *                 name: "Column1",
 *                 type: "STRING",
 *             }],
 *             uploadSettings: {
 *                 format: "JSON",
 *             },
 *         },
 *     }],
 *     columnLevelPermissionRules: [{
 *         columnNames: ["Column1"],
 *         principals: [exampleAwsQuicksightUser&#46;arn],
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.DataSet("example",
 *     data_set_id="example-id",
 *     name="example-name",
 *     import_mode="SPICE",
 *     physical_table_maps=[{
 *         "physical_table_map_id": "example-id",
 *         "s3_source": {
 *             "data_source_arn": example_aws_quicksight_data_source["arn"],
 *             "input_columns": [{
 *                 "name": "Column1",
 *                 "type": "STRING",
 *             }],
 *             "upload_settings": {
 *                 "format": "JSON",
 *             },
 *         },
 *     }],
 *     column_level_permission_rules=[{
 *         "column_names": ["Column1"],
 *         "principals": [example_aws_quicksight_user["arn"]],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.DataSet("example", new()
 *     {
 *         DataSetId = "example-id",
 *         Name = "example-name",
 *         ImportMode = "SPICE",
 *         PhysicalTableMaps = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPhysicalTableMapArgs
 *             {
 *                 PhysicalTableMapId = "example-id",
 *                 S3Source = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceArgs
 *                 {
 *                     DataSourceArn = exampleAwsQuicksightDataSource.Arn,
 *                     InputColumns = new[]
 *                     {
 *                         new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs
 *                         {
 *                             Name = "Column1",
 *                             Type = "STRING",
 *                         },
 *                     },
 *                     UploadSettings = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs
 *                     {
 *                         Format = "JSON",
 *                     },
 *                 },
 *             },
 *         },
 *         ColumnLevelPermissionRules = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetColumnLevelPermissionRuleArgs
 *             {
 *                 ColumnNames = new[]
 *                 {
 *                     "Column1",
 *                 },
 *                 Principals = new[]
 *                 {
 *                     exampleAwsQuicksightUser.Arn,
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSet(ctx, "example", &quicksight.DataSetArgs{
 * 			DataSetId:  pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			ImportMode: pulumi.String("SPICE"),
 * 			PhysicalTableMaps: quicksight.DataSetPhysicalTableMapArray{
 * 				&quicksight.DataSetPhysicalTableMapArgs{
 * 					PhysicalTableMapId: pulumi.String("example-id"),
 * 					S3Source: &quicksight.DataSetPhysicalTableMapS3SourceArgs{
 * 						DataSourceArn: pulumi.Any(exampleAwsQuicksightDataSource.Arn),
 * 						InputColumns: quicksight.DataSetPhysicalTableMapS3SourceInputColumnArray{
 * 							&quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs{
 * 								Name: pulumi.String("Column1"),
 * 								Type: pulumi.String("STRING"),
 * 							},
 * 						},
 * 						UploadSettings: &quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs{
 * 							Format: pulumi.String("JSON"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ColumnLevelPermissionRules: quicksight.DataSetColumnLevelPermissionRuleArray{
 * 				&quicksight.DataSetColumnLevelPermissionRuleArgs{
 * 					ColumnNames: pulumi.StringArray{
 * 						pulumi.String("Column1"),
 * 					},
 * 					Principals: pulumi.StringArray{
 * 						exampleAwsQuicksightUser.Arn,
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetColumnLevelPermissionRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .name("example-name")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(exampleAwsQuicksightDataSource.arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .columnLevelPermissionRules(DataSetColumnLevelPermissionRuleArgs.builder()
 *                 .columnNames("Column1")
 *                 .principals(exampleAwsQuicksightUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:DataSet
 *     properties:
 *       dataSetId: example-id
 *       name: example-name
 *       importMode: SPICE
 *       physicalTableMaps:
 *         - physicalTableMapId: example-id
 *           s3Source:
 *             dataSourceArn: ${exampleAwsQuicksightDataSource.arn}
 *             inputColumns:
 *               - name: Column1
 *                 type: STRING
 *             uploadSettings:
 *               format: JSON
 *       columnLevelPermissionRules:
 *         - columnNames:
 *             - Column1
 *           principals:
 *             - ${exampleAwsQuicksightUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Field Folders
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.DataSet("example", {
 *     dataSetId: "example-id",
 *     name: "example-name",
 *     importMode: "SPICE",
 *     physicalTableMaps: [{
 *         physicalTableMapId: "example-id",
 *         s3Source: {
 *             dataSourceArn: exampleAwsQuicksightDataSource.arn,
 *             inputColumns: [{
 *                 name: "Column1",
 *                 type: "STRING",
 *             }],
 *             uploadSettings: {
 *                 format: "JSON",
 *             },
 *         },
 *     }],
 *     fieldFolders: [{
 *         fieldFoldersId: "example-id",
 *         columns: ["Column1"],
 *         description: "example description",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.DataSet("example",
 *     data_set_id="example-id",
 *     name="example-name",
 *     import_mode="SPICE",
 *     physical_table_maps=[{
 *         "physical_table_map_id": "example-id",
 *         "s3_source": {
 *             "data_source_arn": example_aws_quicksight_data_source["arn"],
 *             "input_columns": [{
 *                 "name": "Column1",
 *                 "type": "STRING",
 *             }],
 *             "upload_settings": {
 *                 "format": "JSON",
 *             },
 *         },
 *     }],
 *     field_folders=[{
 *         "field_folders_id": "example-id",
 *         "columns": ["Column1"],
 *         "description": "example description",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.DataSet("example", new()
 *     {
 *         DataSetId = "example-id",
 *         Name = "example-name",
 *         ImportMode = "SPICE",
 *         PhysicalTableMaps = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPhysicalTableMapArgs
 *             {
 *                 PhysicalTableMapId = "example-id",
 *                 S3Source = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceArgs
 *                 {
 *                     DataSourceArn = exampleAwsQuicksightDataSource.Arn,
 *                     InputColumns = new[]
 *                     {
 *                         new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs
 *                         {
 *                             Name = "Column1",
 *                             Type = "STRING",
 *                         },
 *                     },
 *                     UploadSettings = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs
 *                     {
 *                         Format = "JSON",
 *                     },
 *                 },
 *             },
 *         },
 *         FieldFolders = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetFieldFolderArgs
 *             {
 *                 FieldFoldersId = "example-id",
 *                 Columns = new[]
 *                 {
 *                     "Column1",
 *                 },
 *                 Description = "example description",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSet(ctx, "example", &quicksight.DataSetArgs{
 * 			DataSetId:  pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			ImportMode: pulumi.String("SPICE"),
 * 			PhysicalTableMaps: quicksight.DataSetPhysicalTableMapArray{
 * 				&quicksight.DataSetPhysicalTableMapArgs{
 * 					PhysicalTableMapId: pulumi.String("example-id"),
 * 					S3Source: &quicksight.DataSetPhysicalTableMapS3SourceArgs{
 * 						DataSourceArn: pulumi.Any(exampleAwsQuicksightDataSource.Arn),
 * 						InputColumns: quicksight.DataSetPhysicalTableMapS3SourceInputColumnArray{
 * 							&quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs{
 * 								Name: pulumi.String("Column1"),
 * 								Type: pulumi.String("STRING"),
 * 							},
 * 						},
 * 						UploadSettings: &quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs{
 * 							Format: pulumi.String("JSON"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			FieldFolders: quicksight.DataSetFieldFolderArray{
 * 				&quicksight.DataSetFieldFolderArgs{
 * 					FieldFoldersId: pulumi.String("example-id"),
 * 					Columns: pulumi.StringArray{
 * 						pulumi.String("Column1"),
 * 					},
 * 					Description: pulumi.String("example description"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetFieldFolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .name("example-name")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(exampleAwsQuicksightDataSource.arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .fieldFolders(DataSetFieldFolderArgs.builder()
 *                 .fieldFoldersId("example-id")
 *                 .columns("Column1")
 *                 .description("example description")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:DataSet
 *     properties:
 *       dataSetId: example-id
 *       name: example-name
 *       importMode: SPICE
 *       physicalTableMaps:
 *         - physicalTableMapId: example-id
 *           s3Source:
 *             dataSourceArn: ${exampleAwsQuicksightDataSource.arn}
 *             inputColumns:
 *               - name: Column1
 *                 type: STRING
 *             uploadSettings:
 *               format: JSON
 *       fieldFolders:
 *         - fieldFoldersId: example-id
 *           columns:
 *             - Column1
 *           description: example description
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.DataSet("example", {
 *     dataSetId: "example-id",
 *     name: "example-name",
 *     importMode: "SPICE",
 *     physicalTableMaps: [{
 *         physicalTableMapId: "example-id",
 *         s3Source: {
 *             dataSourceArn: exampleAwsQuicksightDataSource.arn,
 *             inputColumns: [{
 *                 name: "Column1",
 *                 type: "STRING",
 *             }],
 *             uploadSettings: {
 *                 format: "JSON",
 *             },
 *         },
 *     }],
 *     permissions: [{
 *         actions: [
 *             "quicksight:DescribeDataSet",
 *             "quicksight:DescribeDataSetPermissions",
 *             "quicksight:PassDataSet",
 *             "quicksight:DescribeIngestion",
 *             "quicksight:ListIngestions",
 *         ],
 *         principal: exampleAwsQuicksightUser.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.DataSet("example",
 *     data_set_id="example-id",
 *     name="example-name",
 *     import_mode="SPICE",
 *     physical_table_maps=[{
 *         "physical_table_map_id": "example-id",
 *         "s3_source": {
 *             "data_source_arn": example_aws_quicksight_data_source["arn"],
 *             "input_columns": [{
 *                 "name": "Column1",
 *                 "type": "STRING",
 *             }],
 *             "upload_settings": {
 *                 "format": "JSON",
 *             },
 *         },
 *     }],
 *     permissions=[{
 *         "actions": [
 *             "quicksight:DescribeDataSet",
 *             "quicksight:DescribeDataSetPermissions",
 *             "quicksight:PassDataSet",
 *             "quicksight:DescribeIngestion",
 *             "quicksight:ListIngestions",
 *         ],
 *         "principal": example_aws_quicksight_user["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.DataSet("example", new()
 *     {
 *         DataSetId = "example-id",
 *         Name = "example-name",
 *         ImportMode = "SPICE",
 *         PhysicalTableMaps = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPhysicalTableMapArgs
 *             {
 *                 PhysicalTableMapId = "example-id",
 *                 S3Source = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceArgs
 *                 {
 *                     DataSourceArn = exampleAwsQuicksightDataSource.Arn,
 *                     InputColumns = new[]
 *                     {
 *                         new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs
 *                         {
 *                             Name = "Column1",
 *                             Type = "STRING",
 *                         },
 *                     },
 *                     UploadSettings = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs
 *                     {
 *                         Format = "JSON",
 *                     },
 *                 },
 *             },
 *         },
 *         Permissions = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPermissionArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "quicksight:DescribeDataSet",
 *                     "quicksight:DescribeDataSetPermissions",
 *                     "quicksight:PassDataSet",
 *                     "quicksight:DescribeIngestion",
 *                     "quicksight:ListIngestions",
 *                 },
 *                 Principal = exampleAwsQuicksightUser.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSet(ctx, "example", &quicksight.DataSetArgs{
 * 			DataSetId:  pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			ImportMode: pulumi.String("SPICE"),
 * 			PhysicalTableMaps: quicksight.DataSetPhysicalTableMapArray{
 * 				&quicksight.DataSetPhysicalTableMapArgs{
 * 					PhysicalTableMapId: pulumi.String("example-id"),
 * 					S3Source: &quicksight.DataSetPhysicalTableMapS3SourceArgs{
 * 						DataSourceArn: pulumi.Any(exampleAwsQuicksightDataSource.Arn),
 * 						InputColumns: quicksight.DataSetPhysicalTableMapS3SourceInputColumnArray{
 * 							&quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs{
 * 								Name: pulumi.String("Column1"),
 * 								Type: pulumi.String("STRING"),
 * 							},
 * 						},
 * 						UploadSettings: &quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs{
 * 							Format: pulumi.String("JSON"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Permissions: quicksight.DataSetPermissionArray{
 * 				&quicksight.DataSetPermissionArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("quicksight:DescribeDataSet"),
 * 						pulumi.String("quicksight:DescribeDataSetPermissions"),
 * 						pulumi.String("quicksight:PassDataSet"),
 * 						pulumi.String("quicksight:DescribeIngestion"),
 * 						pulumi.String("quicksight:ListIngestions"),
 * 					},
 * 					Principal: pulumi.Any(exampleAwsQuicksightUser.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .name("example-name")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(exampleAwsQuicksightDataSource.arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .permissions(DataSetPermissionArgs.builder()
 *                 .actions(
 *                     "quicksight:DescribeDataSet",
 *                     "quicksight:DescribeDataSetPermissions",
 *                     "quicksight:PassDataSet",
 *                     "quicksight:DescribeIngestion",
 *                     "quicksight:ListIngestions")
 *                 .principal(exampleAwsQuicksightUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:DataSet
 *     properties:
 *       dataSetId: example-id
 *       name: example-name
 *       importMode: SPICE
 *       physicalTableMaps:
 *         - physicalTableMapId: example-id
 *           s3Source:
 *             dataSourceArn: ${exampleAwsQuicksightDataSource.arn}
 *             inputColumns:
 *               - name: Column1
 *                 type: STRING
 *             uploadSettings:
 *               format: JSON
 *       permissions:
 *         - actions:
 *             - quicksight:DescribeDataSet
 *             - quicksight:DescribeDataSetPermissions
 *             - quicksight:PassDataSet
 *             - quicksight:DescribeIngestion
 *             - quicksight:ListIngestions
 *           principal: ${exampleAwsQuicksightUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Row Level Permission Tag Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.DataSet("example", {
 *     dataSetId: "example-id",
 *     name: "example-name",
 *     importMode: "SPICE",
 *     physicalTableMaps: [{
 *         physicalTableMapId: "example-id",
 *         s3Source: {
 *             dataSourceArn: exampleAwsQuicksightDataSource.arn,
 *             inputColumns: [{
 *                 name: "Column1",
 *                 type: "STRING",
 *             }],
 *             uploadSettings: {
 *                 format: "JSON",
 *             },
 *         },
 *     }],
 *     rowLevelPermissionTagConfiguration: {
 *         status: "ENABLED",
 *         tagRules: [{
 *             columnName: "Column1",
 *             tagKey: "tagkey",
 *             matchAllValue: "*",
 *             tagMultiValueDelimiter: ",",
 *         }],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.DataSet("example",
 *     data_set_id="example-id",
 *     name="example-name",
 *     import_mode="SPICE",
 *     physical_table_maps=[{
 *         "physical_table_map_id": "example-id",
 *         "s3_source": {
 *             "data_source_arn": example_aws_quicksight_data_source["arn"],
 *             "input_columns": [{
 *                 "name": "Column1",
 *                 "type": "STRING",
 *             }],
 *             "upload_settings": {
 *                 "format": "JSON",
 *             },
 *         },
 *     }],
 *     row_level_permission_tag_configuration={
 *         "status": "ENABLED",
 *         "tag_rules": [{
 *             "column_name": "Column1",
 *             "tag_key": "tagkey",
 *             "match_all_value": "*",
 *             "tag_multi_value_delimiter": ",",
 *         }],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.DataSet("example", new()
 *     {
 *         DataSetId = "example-id",
 *         Name = "example-name",
 *         ImportMode = "SPICE",
 *         PhysicalTableMaps = new[]
 *         {
 *             new Aws.Quicksight.Inputs.DataSetPhysicalTableMapArgs
 *             {
 *                 PhysicalTableMapId = "example-id",
 *                 S3Source = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceArgs
 *                 {
 *                     DataSourceArn = exampleAwsQuicksightDataSource.Arn,
 *                     InputColumns = new[]
 *                     {
 *                         new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs
 *                         {
 *                             Name = "Column1",
 *                             Type = "STRING",
 *                         },
 *                     },
 *                     UploadSettings = new Aws.Quicksight.Inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs
 *                     {
 *                         Format = "JSON",
 *                     },
 *                 },
 *             },
 *         },
 *         RowLevelPermissionTagConfiguration = new Aws.Quicksight.Inputs.DataSetRowLevelPermissionTagConfigurationArgs
 *         {
 *             Status = "ENABLED",
 *             TagRules = new[]
 *             {
 *                 new Aws.Quicksight.Inputs.DataSetRowLevelPermissionTagConfigurationTagRuleArgs
 *                 {
 *                     ColumnName = "Column1",
 *                     TagKey = "tagkey",
 *                     MatchAllValue = "*",
 *                     TagMultiValueDelimiter = ",",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSet(ctx, "example", &quicksight.DataSetArgs{
 * 			DataSetId:  pulumi.String("example-id"),
 * 			Name:       pulumi.String("example-name"),
 * 			ImportMode: pulumi.String("SPICE"),
 * 			PhysicalTableMaps: quicksight.DataSetPhysicalTableMapArray{
 * 				&quicksight.DataSetPhysicalTableMapArgs{
 * 					PhysicalTableMapId: pulumi.String("example-id"),
 * 					S3Source: &quicksight.DataSetPhysicalTableMapS3SourceArgs{
 * 						DataSourceArn: pulumi.Any(exampleAwsQuicksightDataSource.Arn),
 * 						InputColumns: quicksight.DataSetPhysicalTableMapS3SourceInputColumnArray{
 * 							&quicksight.DataSetPhysicalTableMapS3SourceInputColumnArgs{
 * 								Name: pulumi.String("Column1"),
 * 								Type: pulumi.String("STRING"),
 * 							},
 * 						},
 * 						UploadSettings: &quicksight.DataSetPhysicalTableMapS3SourceUploadSettingsArgs{
 * 							Format: pulumi.String("JSON"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			RowLevelPermissionTagConfiguration: &quicksight.DataSetRowLevelPermissionTagConfigurationArgs{
 * 				Status: pulumi.String("ENABLED"),
 * 				TagRules: quicksight.DataSetRowLevelPermissionTagConfigurationTagRuleArray{
 * 					&quicksight.DataSetRowLevelPermissionTagConfigurationTagRuleArgs{
 * 						ColumnName:             pulumi.String("Column1"),
 * 						TagKey:                 pulumi.String("tagkey"),
 * 						MatchAllValue:          pulumi.String("*"),
 * 						TagMultiValueDelimiter: pulumi.String(","),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSet;
 * import com.pulumi.aws.quicksight.DataSetArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceUploadSettingsArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSetRowLevelPermissionTagConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DataSet("example", DataSetArgs.builder()
 *             .dataSetId("example-id")
 *             .name("example-name")
 *             .importMode("SPICE")
 *             .physicalTableMaps(DataSetPhysicalTableMapArgs.builder()
 *                 .physicalTableMapId("example-id")
 *                 .s3Source(DataSetPhysicalTableMapS3SourceArgs.builder()
 *                     .dataSourceArn(exampleAwsQuicksightDataSource.arn())
 *                     .inputColumns(DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
 *                         .name("Column1")
 *                         .type("STRING")
 *                         .build())
 *                     .uploadSettings(DataSetPhysicalTableMapS3SourceUploadSettingsArgs.builder()
 *                         .format("JSON")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .rowLevelPermissionTagConfiguration(DataSetRowLevelPermissionTagConfigurationArgs.builder()
 *                 .status("ENABLED")
 *                 .tagRules(DataSetRowLevelPermissionTagConfigurationTagRuleArgs.builder()
 *                     .columnName("Column1")
 *                     .tagKey("tagkey")
 *                     .matchAllValue("*")
 *                     .tagMultiValueDelimiter(",")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:DataSet
 *     properties:
 *       dataSetId: example-id
 *       name: example-name
 *       importMode: SPICE
 *       physicalTableMaps:
 *         - physicalTableMapId: example-id
 *           s3Source:
 *             dataSourceArn: ${exampleAwsQuicksightDataSource.arn}
 *             inputColumns:
 *               - name: Column1
 *                 type: STRING
 *             uploadSettings:
 *               format: JSON
 *       rowLevelPermissionTagConfiguration:
 *         status: ENABLED
 *         tagRules:
 *           - columnName: Column1
 *             tagKey: tagkey
 *             matchAllValue: '*'
 *             tagMultiValueDelimiter: ','
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Data Set using the AWS account ID and data set ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/dataSet:DataSet example 123456789012,example-id
 * ```
 */
public class DataSet internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.DataSet,
) : KotlinCustomResource(javaResource, DataSetMapper) {
    /**
     * Amazon Resource Name (ARN) of the data set.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * Groupings of columns that work together in certain Amazon QuickSight features. Currently, only geospatial hierarchy is supported. See column_groups.
     */
    public val columnGroups: Output<List<DataSetColumnGroup>>?
        get() = javaResource.columnGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataSetColumnGroupToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * A set of 1 or more definitions of a [ColumnLevelPermissionRule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ColumnLevelPermissionRule.html). See column_level_permission_rules.
     */
    public val columnLevelPermissionRules: Output<List<DataSetColumnLevelPermissionRule>>?
        get() = javaResource.columnLevelPermissionRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dataSetColumnLevelPermissionRuleToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Identifier for the data set.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * The usage configuration to apply to child datasets that reference this dataset as a source. See data_set_usage_configuration.
     */
    public val dataSetUsageConfiguration: Output<DataSetDataSetUsageConfiguration>
        get() = javaResource.dataSetUsageConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                dataSetDataSetUsageConfigurationToKotlin(args0)
            })
        })

    /**
     * The folder that contains fields and nested subfolders for your dataset. See field_folders.
     */
    public val fieldFolders: Output<List<DataSetFieldFolder>>?
        get() = javaResource.fieldFolders().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataSetFieldFolderToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Indicates whether you want to import the data into SPICE. Valid values are `SPICE` and `DIRECT_QUERY`.
     */
    public val importMode: Output<String>
        get() = javaResource.importMode().applyValue({ args0 -> args0 })

    /**
     * Configures the combination and transformation of the data from the physical tables. Maximum of 1 entry. See logical_table_map.
     */
    public val logicalTableMaps: Output<List<DataSetLogicalTableMap>>
        get() = javaResource.logicalTableMaps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSetLogicalTableMapToKotlin(args0) })
            })
        })

    /**
     * Display name for the dataset.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val outputColumns: Output<List<DataSetOutputColumn>>
        get() = javaResource.outputColumns().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSetOutputColumnToKotlin(args0) })
            })
        })

    /**
     * A set of resource permissions on the data source. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<DataSetPermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataSetPermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Declares the physical tables that are available in the underlying data sources. See physical_table_map.
     * The following arguments are optional:
     */
    public val physicalTableMaps: Output<List<DataSetPhysicalTableMap>>?
        get() = javaResource.physicalTableMaps().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        dataSetPhysicalTableMapToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * The refresh properties for the data set. **NOTE**: Only valid when `import_mode` is set to `SPICE`. See refresh_properties.
     */
    public val refreshProperties: Output<DataSetRefreshProperties>?
        get() = javaResource.refreshProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSetRefreshPropertiesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The row-level security configuration for the data that you want to create. See row_level_permission_data_set.
     */
    public val rowLevelPermissionDataSet: Output<DataSetRowLevelPermissionDataSet>?
        get() = javaResource.rowLevelPermissionDataSet().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSetRowLevelPermissionDataSetToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The configuration of tags on a dataset to set row-level security. Row-level security tags are currently supported for anonymous embedding only. See row_level_permission_tag_configuration.
     */
    public val rowLevelPermissionTagConfiguration: Output<DataSetRowLevelPermissionTagConfiguration>?
        get() = javaResource.rowLevelPermissionTagConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSetRowLevelPermissionTagConfigurationToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object DataSetMapper : ResourceMapper<DataSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.DataSet::class == javaResource::class

    override fun map(javaResource: Resource): DataSet = DataSet(
        javaResource as
            com.pulumi.aws.quicksight.DataSet,
    )
}

/**
 * @see [DataSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSet].
 */
public suspend fun dataSet(name: String, block: suspend DataSetResourceBuilder.() -> Unit): DataSet {
    val builder = DataSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSet(name: String): DataSet {
    val builder = DataSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
