@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceCredentials
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParameters
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourcePermission
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceSslProperties
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceVpcConnectionProperties
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceCredentials.Companion.toKotlin as dataSourceCredentialsToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceParameters.Companion.toKotlin as dataSourceParametersToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourcePermission.Companion.toKotlin as dataSourcePermissionToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceSslProperties.Companion.toKotlin as dataSourceSslPropertiesToKotlin
import com.pulumi.aws.quicksight.kotlin.outputs.DataSourceVpcConnectionProperties.Companion.toKotlin as dataSourceVpcConnectionPropertiesToKotlin

/**
 * Builder for [DataSource].
 */
@PulumiTagMarker
public class DataSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataSourceArgs = DataSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataSourceArgsBuilder.() -> Unit) {
        val builder = DataSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataSource {
        val builtJavaResource = com.pulumi.aws.quicksight.DataSource(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DataSource(builtJavaResource)
    }
}

/**
 * Resource for managing QuickSight Data Source
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.quicksight.DataSource("default", {
 *     dataSourceId: "example-id",
 *     name: "My Cool Data in S3",
 *     parameters: {
 *         s3: {
 *             manifestFileLocation: {
 *                 bucket: "my-bucket",
 *                 key: "path/to/manifest.json",
 *             },
 *         },
 *     },
 *     type: "S3",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.quicksight.DataSource("default",
 *     data_source_id="example-id",
 *     name="My Cool Data in S3",
 *     parameters={
 *         "s3": {
 *             "manifest_file_location": {
 *                 "bucket": "my-bucket",
 *                 "key": "path/to/manifest.json",
 *             },
 *         },
 *     },
 *     type="S3")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Quicksight.DataSource("default", new()
 *     {
 *         DataSourceId = "example-id",
 *         Name = "My Cool Data in S3",
 *         Parameters = new Aws.Quicksight.Inputs.DataSourceParametersArgs
 *         {
 *             S3 = new Aws.Quicksight.Inputs.DataSourceParametersS3Args
 *             {
 *                 ManifestFileLocation = new Aws.Quicksight.Inputs.DataSourceParametersS3ManifestFileLocationArgs
 *                 {
 *                     Bucket = "my-bucket",
 *                     Key = "path/to/manifest.json",
 *                 },
 *             },
 *         },
 *         Type = "S3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSource(ctx, "default", &quicksight.DataSourceArgs{
 * 			DataSourceId: pulumi.String("example-id"),
 * 			Name:         pulumi.String("My Cool Data in S3"),
 * 			Parameters: &quicksight.DataSourceParametersArgs{
 * 				S3: &quicksight.DataSourceParametersS3Args{
 * 					ManifestFileLocation: &quicksight.DataSourceParametersS3ManifestFileLocationArgs{
 * 						Bucket: pulumi.String("my-bucket"),
 * 						Key:    pulumi.String("path/to/manifest.json"),
 * 					},
 * 				},
 * 			},
 * 			Type: pulumi.String("S3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSource;
 * import com.pulumi.aws.quicksight.DataSourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DataSource("default", DataSourceArgs.builder()
 *             .dataSourceId("example-id")
 *             .name("My Cool Data in S3")
 *             .parameters(DataSourceParametersArgs.builder()
 *                 .s3(DataSourceParametersS3Args.builder()
 *                     .manifestFileLocation(DataSourceParametersS3ManifestFileLocationArgs.builder()
 *                         .bucket("my-bucket")
 *                         .key("path/to/manifest.json")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .type("S3")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:quicksight:DataSource
 *     properties:
 *       dataSourceId: example-id
 *       name: My Cool Data in S3
 *       parameters:
 *         s3:
 *           manifestFileLocation:
 *             bucket: my-bucket
 *             key: path/to/manifest.json
 *       type: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight data source using the AWS account ID, and data source ID separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/dataSource:DataSource example 123456789123/my-data-source-id
 * ```
 */
public class DataSource internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.DataSource,
) : KotlinCustomResource(javaResource, DataSourceMapper) {
    /**
     * Amazon Resource Name (ARN) of the data source
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID for the AWS account that the data source is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The credentials Amazon QuickSight uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. See Credentials below for more details.
     */
    public val credentials: Output<DataSourceCredentials>?
        get() = javaResource.credentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    dataSourceCredentialsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * An identifier for the data source.
     */
    public val dataSourceId: Output<String>
        get() = javaResource.dataSourceId().applyValue({ args0 -> args0 })

    /**
     * A name for the data source, maximum of 128 characters.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The parameters used to connect to this data source (exactly one).
     */
    public val parameters: Output<DataSourceParameters>
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.let({ args0 ->
                dataSourceParametersToKotlin(args0)
            })
        })

    /**
     * A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    public val permissions: Output<List<DataSourcePermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> dataSourcePermissionToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. See SSL Properties below for more details.
     */
    public val sslProperties: Output<DataSourceSslProperties>?
        get() = javaResource.sslProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceSslPropertiesToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The type of the data source. See the [AWS Documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html#QS-CreateDataSource-request-Type) for the complete list of valid values.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. See VPC Connection Properties below for more details.
     */
    public val vpcConnectionProperties: Output<DataSourceVpcConnectionProperties>?
        get() = javaResource.vpcConnectionProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> dataSourceVpcConnectionPropertiesToKotlin(args0) })
            }).orElse(null)
        })
}

public object DataSourceMapper : ResourceMapper<DataSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.DataSource::class == javaResource::class

    override fun map(javaResource: Resource): DataSource = DataSource(
        javaResource as
            com.pulumi.aws.quicksight.DataSource,
    )
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataSource].
 */
public suspend fun dataSource(name: String, block: suspend DataSourceResourceBuilder.() -> Unit): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataSource(name: String): DataSource {
    val builder = DataSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
