@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.DataSourceArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceCredentialsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceCredentialsArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceParametersArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceParametersArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourcePermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourcePermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceSslPropertiesArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceSslPropertiesArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceVpcConnectionPropertiesArgs
import com.pulumi.aws.quicksight.kotlin.inputs.DataSourceVpcConnectionPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing QuickSight Data Source
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const _default = new aws.quicksight.DataSource("default", {
 *     dataSourceId: "example-id",
 *     name: "My Cool Data in S3",
 *     parameters: {
 *         s3: {
 *             manifestFileLocation: {
 *                 bucket: "my-bucket",
 *                 key: "path/to/manifest.json",
 *             },
 *         },
 *     },
 *     type: "S3",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * default = aws.quicksight.DataSource("default",
 *     data_source_id="example-id",
 *     name="My Cool Data in S3",
 *     parameters={
 *         "s3": {
 *             "manifest_file_location": {
 *                 "bucket": "my-bucket",
 *                 "key": "path/to/manifest.json",
 *             },
 *         },
 *     },
 *     type="S3")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @default = new Aws.Quicksight.DataSource("default", new()
 *     {
 *         DataSourceId = "example-id",
 *         Name = "My Cool Data in S3",
 *         Parameters = new Aws.Quicksight.Inputs.DataSourceParametersArgs
 *         {
 *             S3 = new Aws.Quicksight.Inputs.DataSourceParametersS3Args
 *             {
 *                 ManifestFileLocation = new Aws.Quicksight.Inputs.DataSourceParametersS3ManifestFileLocationArgs
 *                 {
 *                     Bucket = "my-bucket",
 *                     Key = "path/to/manifest.json",
 *                 },
 *             },
 *         },
 *         Type = "S3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewDataSource(ctx, "default", &quicksight.DataSourceArgs{
 * 			DataSourceId: pulumi.String("example-id"),
 * 			Name:         pulumi.String("My Cool Data in S3"),
 * 			Parameters: &quicksight.DataSourceParametersArgs{
 * 				S3: &quicksight.DataSourceParametersS3Args{
 * 					ManifestFileLocation: &quicksight.DataSourceParametersS3ManifestFileLocationArgs{
 * 						Bucket: pulumi.String("my-bucket"),
 * 						Key:    pulumi.String("path/to/manifest.json"),
 * 					},
 * 				},
 * 			},
 * 			Type: pulumi.String("S3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.DataSource;
 * import com.pulumi.aws.quicksight.DataSourceArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersArgs;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3Args;
 * import com.pulumi.aws.quicksight.inputs.DataSourceParametersS3ManifestFileLocationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var default_ = new DataSource("default", DataSourceArgs.builder()
 *             .dataSourceId("example-id")
 *             .name("My Cool Data in S3")
 *             .parameters(DataSourceParametersArgs.builder()
 *                 .s3(DataSourceParametersS3Args.builder()
 *                     .manifestFileLocation(DataSourceParametersS3ManifestFileLocationArgs.builder()
 *                         .bucket("my-bucket")
 *                         .key("path/to/manifest.json")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .type("S3")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   default:
 *     type: aws:quicksight:DataSource
 *     properties:
 *       dataSourceId: example-id
 *       name: My Cool Data in S3
 *       parameters:
 *         s3:
 *           manifestFileLocation:
 *             bucket: my-bucket
 *             key: path/to/manifest.json
 *       type: S3
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight data source using the AWS account ID, and data source ID separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/dataSource:DataSource example 123456789123/my-data-source-id
 * ```
 * @property awsAccountId The ID for the AWS account that the data source is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
 * @property credentials The credentials Amazon QuickSight uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. See Credentials below for more details.
 * @property dataSourceId An identifier for the data source.
 * @property name A name for the data source, maximum of 128 characters.
 * @property parameters The parameters used to connect to this data source (exactly one).
 * @property permissions A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
 * @property sslProperties Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. See SSL Properties below for more details.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The type of the data source. See the [AWS Documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html#QS-CreateDataSource-request-Type) for the complete list of valid values.
 * The following arguments are optional:
 * @property vpcConnectionProperties Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. See VPC Connection Properties below for more details.
 */
public data class DataSourceArgs(
    public val awsAccountId: Output<String>? = null,
    public val credentials: Output<DataSourceCredentialsArgs>? = null,
    public val dataSourceId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parameters: Output<DataSourceParametersArgs>? = null,
    public val permissions: Output<List<DataSourcePermissionArgs>>? = null,
    public val sslProperties: Output<DataSourceSslPropertiesArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpcConnectionProperties: Output<DataSourceVpcConnectionPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.DataSourceArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.DataSourceArgs =
        com.pulumi.aws.quicksight.DataSourceArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .credentials(credentials?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dataSourceId(dataSourceId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sslProperties(sslProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpcConnectionProperties(
                vpcConnectionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSourceArgs].
 */
@PulumiTagMarker
public class DataSourceArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var credentials: Output<DataSourceCredentialsArgs>? = null

    private var dataSourceId: Output<String>? = null

    private var name: Output<String>? = null

    private var parameters: Output<DataSourceParametersArgs>? = null

    private var permissions: Output<List<DataSourcePermissionArgs>>? = null

    private var sslProperties: Output<DataSourceSslPropertiesArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpcConnectionProperties: Output<DataSourceVpcConnectionPropertiesArgs>? = null

    /**
     * @param value The ID for the AWS account that the data source is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("yiinmxkmhyfqaxsp")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The credentials Amazon QuickSight uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. See Credentials below for more details.
     */
    @JvmName("xowbdnsagcrttiph")
    public suspend fun credentials(`value`: Output<DataSourceCredentialsArgs>) {
        this.credentials = value
    }

    /**
     * @param value An identifier for the data source.
     */
    @JvmName("njsaugsywegwitdn")
    public suspend fun dataSourceId(`value`: Output<String>) {
        this.dataSourceId = value
    }

    /**
     * @param value A name for the data source, maximum of 128 characters.
     */
    @JvmName("viyatmdjkavukarm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The parameters used to connect to this data source (exactly one).
     */
    @JvmName("brpneipgvcgpqtao")
    public suspend fun parameters(`value`: Output<DataSourceParametersArgs>) {
        this.parameters = value
    }

    /**
     * @param value A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("pobcxqhukbvgybus")
    public suspend fun permissions(`value`: Output<List<DataSourcePermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("xeslmlhowvipnjnu")
    public suspend fun permissions(vararg values: Output<DataSourcePermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("fttrhceyuqngkghi")
    public suspend fun permissions(values: List<Output<DataSourcePermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. See SSL Properties below for more details.
     */
    @JvmName("ejmaqohfqtwomrmt")
    public suspend fun sslProperties(`value`: Output<DataSourceSslPropertiesArgs>) {
        this.sslProperties = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ivjvmoliutetvybq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The type of the data source. See the [AWS Documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html#QS-CreateDataSource-request-Type) for the complete list of valid values.
     * The following arguments are optional:
     */
    @JvmName("jiupatjwcaapxpwx")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. See VPC Connection Properties below for more details.
     */
    @JvmName("iexmxmvdkirsmicu")
    public suspend fun vpcConnectionProperties(`value`: Output<DataSourceVpcConnectionPropertiesArgs>) {
        this.vpcConnectionProperties = value
    }

    /**
     * @param value The ID for the AWS account that the data source is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("jcnemawniuvasmox")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The credentials Amazon QuickSight uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. See Credentials below for more details.
     */
    @JvmName("eejwxvokvtgehiof")
    public suspend fun credentials(`value`: DataSourceCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credentials = mapped
    }

    /**
     * @param argument The credentials Amazon QuickSight uses to connect to your underlying source. Currently, only credentials based on user name and password are supported. See Credentials below for more details.
     */
    @JvmName("qppaxdpiusarhpwe")
    public suspend fun credentials(argument: suspend DataSourceCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceCredentialsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credentials = mapped
    }

    /**
     * @param value An identifier for the data source.
     */
    @JvmName("ywagnpbkfdhbucdr")
    public suspend fun dataSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSourceId = mapped
    }

    /**
     * @param value A name for the data source, maximum of 128 characters.
     */
    @JvmName("gyammmmdlsprqjjl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The parameters used to connect to this data source (exactly one).
     */
    @JvmName("dtciatpupaydsneg")
    public suspend fun parameters(`value`: DataSourceParametersArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument The parameters used to connect to this data source (exactly one).
     */
    @JvmName("pgslgkrwjgkrkiai")
    public suspend fun parameters(argument: suspend DataSourceParametersArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceParametersArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param value A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("pxkjqaykwupqxcaq")
    public suspend fun permissions(`value`: List<DataSourcePermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("xvrlfvilqthvtwxp")
    public suspend fun permissions(argument: List<suspend DataSourcePermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSourcePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("abcgwelrvkcpwrmn")
    public suspend fun permissions(vararg argument: suspend DataSourcePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSourcePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("yfjunqlkantekbxm")
    public suspend fun permissions(argument: suspend DataSourcePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(DataSourcePermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the data source. Maximum of 64 items. See Permission below for more details.
     */
    @JvmName("jdavtyxsgctucapg")
    public suspend fun permissions(vararg values: DataSourcePermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. See SSL Properties below for more details.
     */
    @JvmName("arjspkkenretqcus")
    public suspend fun sslProperties(`value`: DataSourceSslPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslProperties = mapped
    }

    /**
     * @param argument Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying source. See SSL Properties below for more details.
     */
    @JvmName("chtbbtgmcggulvnh")
    public suspend fun sslProperties(argument: suspend DataSourceSslPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceSslPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sslProperties = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xsqawslakwcibqyw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aqhqaxdeirquxtag")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The type of the data source. See the [AWS Documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateDataSource.html#QS-CreateDataSource-request-Type) for the complete list of valid values.
     * The following arguments are optional:
     */
    @JvmName("rsndjskhhnithjuj")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. See VPC Connection Properties below for more details.
     */
    @JvmName("xgvfqyjprkiaccss")
    public suspend fun vpcConnectionProperties(`value`: DataSourceVpcConnectionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConnectionProperties = mapped
    }

    /**
     * @param argument Use this parameter only when you want Amazon QuickSight to use a VPC connection when connecting to your underlying source. See VPC Connection Properties below for more details.
     */
    @JvmName("hrboajaliohqikli")
    public suspend fun vpcConnectionProperties(argument: suspend DataSourceVpcConnectionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DataSourceVpcConnectionPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.vpcConnectionProperties = mapped
    }

    internal fun build(): DataSourceArgs = DataSourceArgs(
        awsAccountId = awsAccountId,
        credentials = credentials,
        dataSourceId = dataSourceId,
        name = name,
        parameters = parameters,
        permissions = permissions,
        sslProperties = sslProperties,
        tags = tags,
        type = type,
        vpcConnectionProperties = vpcConnectionProperties,
    )
}
