@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.FolderPermission
import com.pulumi.aws.quicksight.kotlin.outputs.FolderPermission.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Folder].
 */
@PulumiTagMarker
public class FolderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FolderArgs = FolderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FolderArgsBuilder.() -> Unit) {
        val builder = FolderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Folder {
        val builtJavaResource = com.pulumi.aws.quicksight.Folder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Folder(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Folder.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("example-id"),
 * 			Name:     pulumi.String("example-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 *     permissions: [{
 *         actions: [
 *             "quicksight:CreateFolder",
 *             "quicksight:DescribeFolder",
 *             "quicksight:UpdateFolder",
 *             "quicksight:DeleteFolder",
 *             "quicksight:CreateFolderMembership",
 *             "quicksight:DeleteFolderMembership",
 *             "quicksight:DescribeFolderPermissions",
 *             "quicksight:UpdateFolderPermissions",
 *         ],
 *         principal: exampleAwsQuicksightUser.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name",
 *     permissions=[{
 *         "actions": [
 *             "quicksight:CreateFolder",
 *             "quicksight:DescribeFolder",
 *             "quicksight:UpdateFolder",
 *             "quicksight:DeleteFolder",
 *             "quicksight:CreateFolderMembership",
 *             "quicksight:DeleteFolderMembership",
 *             "quicksight:DescribeFolderPermissions",
 *             "quicksight:UpdateFolderPermissions",
 *         ],
 *         "principal": example_aws_quicksight_user["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *         Permissions = new[]
 *         {
 *             new Aws.Quicksight.Inputs.FolderPermissionArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "quicksight:CreateFolder",
 *                     "quicksight:DescribeFolder",
 *                     "quicksight:UpdateFolder",
 *                     "quicksight:DeleteFolder",
 *                     "quicksight:CreateFolderMembership",
 *                     "quicksight:DeleteFolderMembership",
 *                     "quicksight:DescribeFolderPermissions",
 *                     "quicksight:UpdateFolderPermissions",
 *                 },
 *                 Principal = exampleAwsQuicksightUser.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("example-id"),
 * 			Name:     pulumi.String("example-name"),
 * 			Permissions: quicksight.FolderPermissionArray{
 * 				&quicksight.FolderPermissionArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("quicksight:CreateFolder"),
 * 						pulumi.String("quicksight:DescribeFolder"),
 * 						pulumi.String("quicksight:UpdateFolder"),
 * 						pulumi.String("quicksight:DeleteFolder"),
 * 						pulumi.String("quicksight:CreateFolderMembership"),
 * 						pulumi.String("quicksight:DeleteFolderMembership"),
 * 						pulumi.String("quicksight:DescribeFolderPermissions"),
 * 						pulumi.String("quicksight:UpdateFolderPermissions"),
 * 					},
 * 					Principal: pulumi.Any(exampleAwsQuicksightUser.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import com.pulumi.aws.quicksight.inputs.FolderPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .permissions(FolderPermissionArgs.builder()
 *                 .actions(
 *                     "quicksight:CreateFolder",
 *                     "quicksight:DescribeFolder",
 *                     "quicksight:UpdateFolder",
 *                     "quicksight:DeleteFolder",
 *                     "quicksight:CreateFolderMembership",
 *                     "quicksight:DeleteFolderMembership",
 *                     "quicksight:DescribeFolderPermissions",
 *                     "quicksight:UpdateFolderPermissions")
 *                 .principal(exampleAwsQuicksightUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 *       permissions:
 *         - actions:
 *             - quicksight:CreateFolder
 *             - quicksight:DescribeFolder
 *             - quicksight:UpdateFolder
 *             - quicksight:DeleteFolder
 *             - quicksight:CreateFolderMembership
 *             - quicksight:DeleteFolderMembership
 *             - quicksight:DescribeFolderPermissions
 *             - quicksight:UpdateFolderPermissions
 *           principal: ${exampleAwsQuicksightUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Parent Folder
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const parent = new aws.quicksight.Folder("parent", {
 *     folderId: "parent-id",
 *     name: "parent-name",
 * });
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 *     parentFolderArn: parent.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * parent = aws.quicksight.Folder("parent",
 *     folder_id="parent-id",
 *     name="parent-name")
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name",
 *     parent_folder_arn=parent.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var parent = new Aws.Quicksight.Folder("parent", new()
 *     {
 *         FolderId = "parent-id",
 *         Name = "parent-name",
 *     });
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *         ParentFolderArn = parent.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		parent, err := quicksight.NewFolder(ctx, "parent", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("parent-id"),
 * 			Name:     pulumi.String("parent-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId:        pulumi.String("example-id"),
 * 			Name:            pulumi.String("example-name"),
 * 			ParentFolderArn: parent.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new Folder("parent", FolderArgs.builder()
 *             .folderId("parent-id")
 *             .name("parent-name")
 *             .build());
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .parentFolderArn(parent.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   parent:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: parent-id
 *       name: parent-name
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 *       parentFolderArn: ${parent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight folder using the AWS account ID and folder ID name separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/folder:Folder example 123456789012,example-id
 * ```
 */
public class Folder internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.Folder,
) : KotlinCustomResource(javaResource, FolderMapper) {
    /**
     * ARN of the folder.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The time that the folder was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Identifier for the folder.
     */
    public val folderId: Output<String>
        get() = javaResource.folderId().applyValue({ args0 -> args0 })

    /**
     * An array of ancestor ARN strings for the folder. Empty for root-level folders.
     */
    public val folderPaths: Output<List<String>>
        get() = javaResource.folderPaths().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     */
    public val folderType: Output<String>?
        get() = javaResource.folderType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time that the folder was last updated.
     */
    public val lastUpdatedTime: Output<String>
        get() = javaResource.lastUpdatedTime().applyValue({ args0 -> args0 })

    /**
     * Display name for the folder.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     */
    public val parentFolderArn: Output<String>?
        get() = javaResource.parentFolderArn().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    public val permissions: Output<List<FolderPermission>>?
        get() = javaResource.permissions().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FolderMapper : ResourceMapper<Folder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.Folder::class == javaResource::class

    override fun map(javaResource: Resource): Folder = Folder(
        javaResource as
            com.pulumi.aws.quicksight.Folder,
    )
}

/**
 * @see [Folder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Folder].
 */
public suspend fun folder(name: String, block: suspend FolderResourceBuilder.() -> Unit): Folder {
    val builder = FolderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Folder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun folder(name: String): Folder {
    val builder = FolderResourceBuilder()
    builder.name(name)
    return builder.build()
}
