@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.FolderArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.FolderPermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.FolderPermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Folder.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("example-id"),
 * 			Name:     pulumi.String("example-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Permissions
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 *     permissions: [{
 *         actions: [
 *             "quicksight:CreateFolder",
 *             "quicksight:DescribeFolder",
 *             "quicksight:UpdateFolder",
 *             "quicksight:DeleteFolder",
 *             "quicksight:CreateFolderMembership",
 *             "quicksight:DeleteFolderMembership",
 *             "quicksight:DescribeFolderPermissions",
 *             "quicksight:UpdateFolderPermissions",
 *         ],
 *         principal: exampleAwsQuicksightUser.arn,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name",
 *     permissions=[{
 *         "actions": [
 *             "quicksight:CreateFolder",
 *             "quicksight:DescribeFolder",
 *             "quicksight:UpdateFolder",
 *             "quicksight:DeleteFolder",
 *             "quicksight:CreateFolderMembership",
 *             "quicksight:DeleteFolderMembership",
 *             "quicksight:DescribeFolderPermissions",
 *             "quicksight:UpdateFolderPermissions",
 *         ],
 *         "principal": example_aws_quicksight_user["arn"],
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *         Permissions = new[]
 *         {
 *             new Aws.Quicksight.Inputs.FolderPermissionArgs
 *             {
 *                 Actions = new[]
 *                 {
 *                     "quicksight:CreateFolder",
 *                     "quicksight:DescribeFolder",
 *                     "quicksight:UpdateFolder",
 *                     "quicksight:DeleteFolder",
 *                     "quicksight:CreateFolderMembership",
 *                     "quicksight:DeleteFolderMembership",
 *                     "quicksight:DescribeFolderPermissions",
 *                     "quicksight:UpdateFolderPermissions",
 *                 },
 *                 Principal = exampleAwsQuicksightUser.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("example-id"),
 * 			Name:     pulumi.String("example-name"),
 * 			Permissions: quicksight.FolderPermissionArray{
 * 				&quicksight.FolderPermissionArgs{
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("quicksight:CreateFolder"),
 * 						pulumi.String("quicksight:DescribeFolder"),
 * 						pulumi.String("quicksight:UpdateFolder"),
 * 						pulumi.String("quicksight:DeleteFolder"),
 * 						pulumi.String("quicksight:CreateFolderMembership"),
 * 						pulumi.String("quicksight:DeleteFolderMembership"),
 * 						pulumi.String("quicksight:DescribeFolderPermissions"),
 * 						pulumi.String("quicksight:UpdateFolderPermissions"),
 * 					},
 * 					Principal: pulumi.Any(exampleAwsQuicksightUser.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import com.pulumi.aws.quicksight.inputs.FolderPermissionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .permissions(FolderPermissionArgs.builder()
 *                 .actions(
 *                     "quicksight:CreateFolder",
 *                     "quicksight:DescribeFolder",
 *                     "quicksight:UpdateFolder",
 *                     "quicksight:DeleteFolder",
 *                     "quicksight:CreateFolderMembership",
 *                     "quicksight:DeleteFolderMembership",
 *                     "quicksight:DescribeFolderPermissions",
 *                     "quicksight:UpdateFolderPermissions")
 *                 .principal(exampleAwsQuicksightUser.arn())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 *       permissions:
 *         - actions:
 *             - quicksight:CreateFolder
 *             - quicksight:DescribeFolder
 *             - quicksight:UpdateFolder
 *             - quicksight:DeleteFolder
 *             - quicksight:CreateFolderMembership
 *             - quicksight:DeleteFolderMembership
 *             - quicksight:DescribeFolderPermissions
 *             - quicksight:UpdateFolderPermissions
 *           principal: ${exampleAwsQuicksightUser.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Parent Folder
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const parent = new aws.quicksight.Folder("parent", {
 *     folderId: "parent-id",
 *     name: "parent-name",
 * });
 * const example = new aws.quicksight.Folder("example", {
 *     folderId: "example-id",
 *     name: "example-name",
 *     parentFolderArn: parent.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * parent = aws.quicksight.Folder("parent",
 *     folder_id="parent-id",
 *     name="parent-name")
 * example = aws.quicksight.Folder("example",
 *     folder_id="example-id",
 *     name="example-name",
 *     parent_folder_arn=parent.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var parent = new Aws.Quicksight.Folder("parent", new()
 *     {
 *         FolderId = "parent-id",
 *         Name = "parent-name",
 *     });
 *     var example = new Aws.Quicksight.Folder("example", new()
 *     {
 *         FolderId = "example-id",
 *         Name = "example-name",
 *         ParentFolderArn = parent.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		parent, err := quicksight.NewFolder(ctx, "parent", &quicksight.FolderArgs{
 * 			FolderId: pulumi.String("parent-id"),
 * 			Name:     pulumi.String("parent-name"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quicksight.NewFolder(ctx, "example", &quicksight.FolderArgs{
 * 			FolderId:        pulumi.String("example-id"),
 * 			Name:            pulumi.String("example-name"),
 * 			ParentFolderArn: parent.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Folder;
 * import com.pulumi.aws.quicksight.FolderArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var parent = new Folder("parent", FolderArgs.builder()
 *             .folderId("parent-id")
 *             .name("parent-name")
 *             .build());
 *         var example = new Folder("example", FolderArgs.builder()
 *             .folderId("example-id")
 *             .name("example-name")
 *             .parentFolderArn(parent.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   parent:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: parent-id
 *       name: parent-name
 *   example:
 *     type: aws:quicksight:Folder
 *     properties:
 *       folderId: example-id
 *       name: example-name
 *       parentFolderArn: ${parent.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight folder using the AWS account ID and folder ID name separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/folder:Folder example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property folderId Identifier for the folder.
 * @property folderType The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
 * @property name Display name for the folder.
 * The following arguments are optional:
 * @property parentFolderArn The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
 * @property permissions A set of resource permissions on the folder. Maximum of 64 items. See permissions.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FolderArgs(
    public val awsAccountId: Output<String>? = null,
    public val folderId: Output<String>? = null,
    public val folderType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val parentFolderArn: Output<String>? = null,
    public val permissions: Output<List<FolderPermissionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.FolderArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.FolderArgs =
        com.pulumi.aws.quicksight.FolderArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .folderId(folderId?.applyValue({ args0 -> args0 }))
            .folderType(folderType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .parentFolderArn(parentFolderArn?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FolderArgs].
 */
@PulumiTagMarker
public class FolderArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var folderId: Output<String>? = null

    private var folderType: Output<String>? = null

    private var name: Output<String>? = null

    private var parentFolderArn: Output<String>? = null

    private var permissions: Output<List<FolderPermissionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("wxxnhbudkevraiab")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("modmkcqgivvhkyaq")
    public suspend fun folderId(`value`: Output<String>) {
        this.folderId = value
    }

    /**
     * @param value The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     */
    @JvmName("kuksqoplnrxjcgif")
    public suspend fun folderType(`value`: Output<String>) {
        this.folderType = value
    }

    /**
     * @param value Display name for the folder.
     * The following arguments are optional:
     */
    @JvmName("jjgiudsxnefxyihi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     */
    @JvmName("hjepcmoyskivaiqg")
    public suspend fun parentFolderArn(`value`: Output<String>) {
        this.parentFolderArn = value
    }

    /**
     * @param value A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("ckpcumtdvkegfnec")
    public suspend fun permissions(`value`: Output<List<FolderPermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("nghkdbwrkljfskvq")
    public suspend fun permissions(vararg values: Output<FolderPermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("agaxrdqoguregvkk")
    public suspend fun permissions(values: List<Output<FolderPermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bpqnpdcrevuuhbfd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("hddovmrostasejix")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Identifier for the folder.
     */
    @JvmName("ffnycqbqbjokysgd")
    public suspend fun folderId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderId = mapped
    }

    /**
     * @param value The type of folder. By default, it is `SHARED`. Valid values are: `SHARED`.
     */
    @JvmName("hjurqrwiohmuurvk")
    public suspend fun folderType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderType = mapped
    }

    /**
     * @param value Display name for the folder.
     * The following arguments are optional:
     */
    @JvmName("jwcmlqpiknbdedat")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Amazon Resource Name (ARN) for the parent folder. If not set, creates a root-level folder.
     */
    @JvmName("otlncwgxjaptxovc")
    public suspend fun parentFolderArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parentFolderArn = mapped
    }

    /**
     * @param value A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("vxnyotwfvlkgctnx")
    public suspend fun permissions(`value`: List<FolderPermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("fwxrjkqunkjqahnv")
    public suspend fun permissions(argument: List<suspend FolderPermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FolderPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("dhhyojinjgosendw")
    public suspend fun permissions(vararg argument: suspend FolderPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FolderPermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("jytdqpoickruhsup")
    public suspend fun permissions(argument: suspend FolderPermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FolderPermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the folder. Maximum of 64 items. See permissions.
     */
    @JvmName("tpnwdfyclelkkvpk")
    public suspend fun permissions(vararg values: FolderPermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qnoiqopyqvglstgb")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mwemmnqmsquhwdif")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FolderArgs = FolderArgs(
        awsAccountId = awsAccountId,
        folderId = folderId,
        folderType = folderType,
        name = name,
        parentFolderArn = parentFolderArn,
        permissions = permissions,
        tags = tags,
    )
}
