@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [GroupMembership].
 */
@PulumiTagMarker
public class GroupMembershipResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupMembershipArgs = GroupMembershipArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupMembershipArgsBuilder.() -> Unit) {
        val builder = GroupMembershipArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GroupMembership {
        val builtJavaResource = com.pulumi.aws.quicksight.GroupMembership(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GroupMembership(builtJavaResource)
    }
}

/**
 * Resource for managing QuickSight Group Membership
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.GroupMembership("example", {
 *     groupName: "all-access-users",
 *     memberName: "john_smith",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.GroupMembership("example",
 *     group_name="all-access-users",
 *     member_name="john_smith")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.GroupMembership("example", new()
 *     {
 *         GroupName = "all-access-users",
 *         MemberName = "john_smith",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewGroupMembership(ctx, "example", &quicksight.GroupMembershipArgs{
 * 			GroupName:  pulumi.String("all-access-users"),
 * 			MemberName: pulumi.String("john_smith"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.GroupMembership;
 * import com.pulumi.aws.quicksight.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupMembership("example", GroupMembershipArgs.builder()
 *             .groupName("all-access-users")
 *             .memberName("john_smith")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:GroupMembership
 *     properties:
 *       groupName: all-access-users
 *       memberName: john_smith
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight Group membership using the AWS account ID, namespace, group name and member name separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:quicksight/groupMembership:GroupMembership example 123456789123/default/all-access-users/john_smith
 * ```
 */
public class GroupMembership internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.GroupMembership,
) : KotlinCustomResource(javaResource, GroupMembershipMapper) {
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The name of the group in which the member will be added.
     */
    public val groupName: Output<String>
        get() = javaResource.groupName().applyValue({ args0 -> args0 })

    /**
     * The name of the member to add to the group.
     */
    public val memberName: Output<String>
        get() = javaResource.memberName().applyValue({ args0 -> args0 })

    /**
     * The namespace that you want the user to be a part of. Defaults to `default`.
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GroupMembershipMapper : ResourceMapper<GroupMembership> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.GroupMembership::class == javaResource::class

    override fun map(javaResource: Resource): GroupMembership = GroupMembership(
        javaResource as
            com.pulumi.aws.quicksight.GroupMembership,
    )
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GroupMembership].
 */
public suspend fun groupMembership(
    name: String,
    block: suspend GroupMembershipResourceBuilder.() -> Unit,
): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GroupMembership].
 * @param name The _unique_ name of the resulting resource.
 */
public fun groupMembership(name: String): GroupMembership {
    val builder = GroupMembershipResourceBuilder()
    builder.name(name)
    return builder.build()
}
