@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.GroupMembershipArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing QuickSight Group Membership
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.GroupMembership("example", {
 *     groupName: "all-access-users",
 *     memberName: "john_smith",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.GroupMembership("example",
 *     group_name="all-access-users",
 *     member_name="john_smith")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.GroupMembership("example", new()
 *     {
 *         GroupName = "all-access-users",
 *         MemberName = "john_smith",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewGroupMembership(ctx, "example", &quicksight.GroupMembershipArgs{
 * 			GroupName:  pulumi.String("all-access-users"),
 * 			MemberName: pulumi.String("john_smith"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.GroupMembership;
 * import com.pulumi.aws.quicksight.GroupMembershipArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new GroupMembership("example", GroupMembershipArgs.builder()
 *             .groupName("all-access-users")
 *             .memberName("john_smith")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:GroupMembership
 *     properties:
 *       groupName: all-access-users
 *       memberName: john_smith
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight Group membership using the AWS account ID, namespace, group name and member name separated by `/`. For example:
 * ```sh
 * $ pulumi import aws:quicksight/groupMembership:GroupMembership example 123456789123/default/all-access-users/john_smith
 * ```
 * @property awsAccountId The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
 * @property groupName The name of the group in which the member will be added.
 * @property memberName The name of the member to add to the group.
 * @property namespace The namespace that you want the user to be a part of. Defaults to `default`.
 */
public data class GroupMembershipArgs(
    public val awsAccountId: Output<String>? = null,
    public val groupName: Output<String>? = null,
    public val memberName: Output<String>? = null,
    public val namespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.GroupMembershipArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.GroupMembershipArgs =
        com.pulumi.aws.quicksight.GroupMembershipArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .groupName(groupName?.applyValue({ args0 -> args0 }))
            .memberName(memberName?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMembershipArgs].
 */
@PulumiTagMarker
public class GroupMembershipArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var groupName: Output<String>? = null

    private var memberName: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("rxpugtnconsxtuti")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The name of the group in which the member will be added.
     */
    @JvmName("dotosoqxrenfrhjk")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The name of the member to add to the group.
     */
    @JvmName("ouqoiewesqirtivj")
    public suspend fun memberName(`value`: Output<String>) {
        this.memberName = value
    }

    /**
     * @param value The namespace that you want the user to be a part of. Defaults to `default`.
     */
    @JvmName("ejdotaakrnloxntm")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The ID for the AWS account that the group is in. Currently, you use the ID for the AWS account that contains your Amazon QuickSight account.
     */
    @JvmName("jauwynjujbpfjawt")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The name of the group in which the member will be added.
     */
    @JvmName("wbenxnqvmpgxgrnx")
    public suspend fun groupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    /**
     * @param value The name of the member to add to the group.
     */
    @JvmName("pansvdjsxisowpan")
    public suspend fun memberName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.memberName = mapped
    }

    /**
     * @param value The namespace that you want the user to be a part of. Defaults to `default`.
     */
    @JvmName("irxfpmpjaqgbhcuw")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): GroupMembershipArgs = GroupMembershipArgs(
        awsAccountId = awsAccountId,
        groupName = groupName,
        memberName = memberName,
        namespace = namespace,
    )
}
