@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.IamPolicyAssignmentArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.IamPolicyAssignmentIdentitiesArgs
import com.pulumi.aws.quicksight.kotlin.inputs.IamPolicyAssignmentIdentitiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight IAM Policy Assignment.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.IamPolicyAssignment("example", {
 *     assignmentName: "example",
 *     assignmentStatus: "ENABLED",
 *     policyArn: exampleAwsIamPolicy.arn,
 *     identities: {
 *         users: [exampleAwsQuicksightUser&#46;userName],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.IamPolicyAssignment("example",
 *     assignment_name="example",
 *     assignment_status="ENABLED",
 *     policy_arn=example_aws_iam_policy["arn"],
 *     identities={
 *         "users": [example_aws_quicksight_user["userName"]],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.IamPolicyAssignment("example", new()
 *     {
 *         AssignmentName = "example",
 *         AssignmentStatus = "ENABLED",
 *         PolicyArn = exampleAwsIamPolicy.Arn,
 *         Identities = new Aws.Quicksight.Inputs.IamPolicyAssignmentIdentitiesArgs
 *         {
 *             Users = new[]
 *             {
 *                 exampleAwsQuicksightUser.UserName,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewIamPolicyAssignment(ctx, "example", &quicksight.IamPolicyAssignmentArgs{
 * 			AssignmentName:   pulumi.String("example"),
 * 			AssignmentStatus: pulumi.String("ENABLED"),
 * 			PolicyArn:        pulumi.Any(exampleAwsIamPolicy.Arn),
 * 			Identities: &quicksight.IamPolicyAssignmentIdentitiesArgs{
 * 				Users: pulumi.StringArray{
 * 					exampleAwsQuicksightUser.UserName,
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.IamPolicyAssignment;
 * import com.pulumi.aws.quicksight.IamPolicyAssignmentArgs;
 * import com.pulumi.aws.quicksight.inputs.IamPolicyAssignmentIdentitiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IamPolicyAssignment("example", IamPolicyAssignmentArgs.builder()
 *             .assignmentName("example")
 *             .assignmentStatus("ENABLED")
 *             .policyArn(exampleAwsIamPolicy.arn())
 *             .identities(IamPolicyAssignmentIdentitiesArgs.builder()
 *                 .users(exampleAwsQuicksightUser.userName())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:IamPolicyAssignment
 *     properties:
 *       assignmentName: example
 *       assignmentStatus: ENABLED
 *       policyArn: ${exampleAwsIamPolicy.arn}
 *       identities:
 *         users:
 *           - ${exampleAwsQuicksightUser.userName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight IAM Policy Assignment using the AWS account ID, namespace, and assignment name separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/iamPolicyAssignment:IamPolicyAssignment example 123456789012,default,example
 * ```
 * @property assignmentName Name of the assignment.
 * @property assignmentStatus Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
 * The following arguments are optional:
 * @property awsAccountId AWS account ID.
 * @property identities Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
 * @property namespace Namespace that contains the assignment. Defaults to `default`.
 * @property policyArn ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
 */
public data class IamPolicyAssignmentArgs(
    public val assignmentName: Output<String>? = null,
    public val assignmentStatus: Output<String>? = null,
    public val awsAccountId: Output<String>? = null,
    public val identities: Output<IamPolicyAssignmentIdentitiesArgs>? = null,
    public val namespace: Output<String>? = null,
    public val policyArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.IamPolicyAssignmentArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.IamPolicyAssignmentArgs =
        com.pulumi.aws.quicksight.IamPolicyAssignmentArgs.builder()
            .assignmentName(assignmentName?.applyValue({ args0 -> args0 }))
            .assignmentStatus(assignmentStatus?.applyValue({ args0 -> args0 }))
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .identities(identities?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .policyArn(policyArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IamPolicyAssignmentArgs].
 */
@PulumiTagMarker
public class IamPolicyAssignmentArgsBuilder internal constructor() {
    private var assignmentName: Output<String>? = null

    private var assignmentStatus: Output<String>? = null

    private var awsAccountId: Output<String>? = null

    private var identities: Output<IamPolicyAssignmentIdentitiesArgs>? = null

    private var namespace: Output<String>? = null

    private var policyArn: Output<String>? = null

    /**
     * @param value Name of the assignment.
     */
    @JvmName("gscxhxkuwlooncrv")
    public suspend fun assignmentName(`value`: Output<String>) {
        this.assignmentName = value
    }

    /**
     * @param value Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
     * The following arguments are optional:
     */
    @JvmName("txebmntcfxmuxdwp")
    public suspend fun assignmentStatus(`value`: Output<String>) {
        this.assignmentStatus = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("vvjlioyuxiscyikb")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
     */
    @JvmName("kblsaabwjjxtguxs")
    public suspend fun identities(`value`: Output<IamPolicyAssignmentIdentitiesArgs>) {
        this.identities = value
    }

    /**
     * @param value Namespace that contains the assignment. Defaults to `default`.
     */
    @JvmName("favbnnsalewpvatn")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
     */
    @JvmName("oxhyefebfcoubsma")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value Name of the assignment.
     */
    @JvmName("ftmkpfotuebbastl")
    public suspend fun assignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentName = mapped
    }

    /**
     * @param value Status of the assignment. Valid values are `ENABLED`, `DISABLED`, and `DRAFT`.
     * The following arguments are optional:
     */
    @JvmName("rmbqpplwywdqakkr")
    public suspend fun assignmentStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assignmentStatus = mapped
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("rthckyobxttclivm")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
     */
    @JvmName("ifkdlsctombqugsx")
    public suspend fun identities(`value`: IamPolicyAssignmentIdentitiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identities = mapped
    }

    /**
     * @param argument Amazon QuickSight users, groups, or both to assign the policy to. See `identities` block.
     */
    @JvmName("jioogyjwowtcgcnc")
    public suspend fun identities(argument: suspend IamPolicyAssignmentIdentitiesArgsBuilder.() -> Unit) {
        val toBeMapped = IamPolicyAssignmentIdentitiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identities = mapped
    }

    /**
     * @param value Namespace that contains the assignment. Defaults to `default`.
     */
    @JvmName("yginobyynhmpubfm")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value ARN of the IAM policy to apply to the Amazon QuickSight users and groups specified in this assignment.
     */
    @JvmName("odefvdxjgvxlpqps")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    internal fun build(): IamPolicyAssignmentArgs = IamPolicyAssignmentArgs(
        assignmentName = assignmentName,
        assignmentStatus = assignmentStatus,
        awsAccountId = awsAccountId,
        identities = identities,
        namespace = namespace,
        policyArn = policyArn,
    )
}
