@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.IngestionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Ingestion.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Ingestion("example", {
 *     dataSetId: exampleAwsQuicksightDataSet.dataSetId,
 *     ingestionId: "example-id",
 *     ingestionType: "FULL_REFRESH",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Ingestion("example",
 *     data_set_id=example_aws_quicksight_data_set["dataSetId"],
 *     ingestion_id="example-id",
 *     ingestion_type="FULL_REFRESH")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Ingestion("example", new()
 *     {
 *         DataSetId = exampleAwsQuicksightDataSet.DataSetId,
 *         IngestionId = "example-id",
 *         IngestionType = "FULL_REFRESH",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewIngestion(ctx, "example", &quicksight.IngestionArgs{
 * 			DataSetId:     pulumi.Any(exampleAwsQuicksightDataSet.DataSetId),
 * 			IngestionId:   pulumi.String("example-id"),
 * 			IngestionType: pulumi.String("FULL_REFRESH"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Ingestion;
 * import com.pulumi.aws.quicksight.IngestionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Ingestion("example", IngestionArgs.builder()
 *             .dataSetId(exampleAwsQuicksightDataSet.dataSetId())
 *             .ingestionId("example-id")
 *             .ingestionType("FULL_REFRESH")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Ingestion
 *     properties:
 *       dataSetId: ${exampleAwsQuicksightDataSet.dataSetId}
 *       ingestionId: example-id
 *       ingestionType: FULL_REFRESH
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight Ingestion using the AWS account ID, data set ID, and ingestion ID separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/ingestion:Ingestion example 123456789012,example-dataset-id,example-ingestion-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dataSetId ID of the dataset used in the ingestion.
 * @property ingestionId ID for the ingestion.
 * @property ingestionType Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
 * The following arguments are optional:
 */
public data class IngestionArgs(
    public val awsAccountId: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val ingestionId: Output<String>? = null,
    public val ingestionType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.IngestionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.IngestionArgs =
        com.pulumi.aws.quicksight.IngestionArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .ingestionId(ingestionId?.applyValue({ args0 -> args0 }))
            .ingestionType(ingestionType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IngestionArgs].
 */
@PulumiTagMarker
public class IngestionArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var ingestionId: Output<String>? = null

    private var ingestionType: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("gnhmpauyrvlvprcl")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value ID of the dataset used in the ingestion.
     */
    @JvmName("hiogqsomdanjgnjr")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value ID for the ingestion.
     */
    @JvmName("sgrgxdweohwacjkh")
    public suspend fun ingestionId(`value`: Output<String>) {
        this.ingestionId = value
    }

    /**
     * @param value Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * The following arguments are optional:
     */
    @JvmName("jmwqjbeofwfmtupa")
    public suspend fun ingestionType(`value`: Output<String>) {
        this.ingestionType = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("gqedxxolkxdhcrpq")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value ID of the dataset used in the ingestion.
     */
    @JvmName("ixnuraknjfdkcdnn")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value ID for the ingestion.
     */
    @JvmName("guinrqklqycmgtfx")
    public suspend fun ingestionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionId = mapped
    }

    /**
     * @param value Type of ingestion to be created. Valid values are `INCREMENTAL_REFRESH` and `FULL_REFRESH`.
     * The following arguments are optional:
     */
    @JvmName("gcmsfkecgwmgjkgu")
    public suspend fun ingestionType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ingestionType = mapped
    }

    internal fun build(): IngestionArgs = IngestionArgs(
        awsAccountId = awsAccountId,
        dataSetId = dataSetId,
        ingestionId = ingestionId,
        ingestionType = ingestionType,
    )
}
