@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.NamespaceArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.NamespaceTimeoutsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.NamespaceTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight Namespace.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Namespace("example", {namespace: "example"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Namespace("example", namespace="example")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Namespace("example", new()
 *     {
 *         NameSpace = "example",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewNamespace(ctx, "example", &quicksight.NamespaceArgs{
 * 			Namespace: pulumi.String("example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Namespace;
 * import com.pulumi.aws.quicksight.NamespaceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Namespace("example", NamespaceArgs.builder()
 *             .namespace("example")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Namespace
 *     properties:
 *       namespace: example
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight Namespace using the AWS account ID and namespace separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/namespace:Namespace example 123456789012,example
 * ```
 * @property awsAccountId AWS account ID.
 * @property identityStore User identity directory type. Defaults to `QUICKSIGHT`, the only current valid value.
 * @property namespace Name of the namespace.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 */
public data class NamespaceArgs(
    public val awsAccountId: Output<String>? = null,
    public val identityStore: Output<String>? = null,
    public val namespace: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<NamespaceTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.NamespaceArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.NamespaceArgs =
        com.pulumi.aws.quicksight.NamespaceArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .identityStore(identityStore?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [NamespaceArgs].
 */
@PulumiTagMarker
public class NamespaceArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var identityStore: Output<String>? = null

    private var namespace: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<NamespaceTimeoutsArgs>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("fugqwwqvkefolfpp")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value User identity directory type. Defaults to `QUICKSIGHT`, the only current valid value.
     */
    @JvmName("kbnxwnagujwysaof")
    public suspend fun identityStore(`value`: Output<String>) {
        this.identityStore = value
    }

    /**
     * @param value Name of the namespace.
     * The following arguments are optional:
     */
    @JvmName("nyosoetkccepphvy")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jkdtvmudeqwjqaap")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("ovbdvpkuavonauie")
    public suspend fun timeouts(`value`: Output<NamespaceTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("yprwtpafirhdfrfa")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value User identity directory type. Defaults to `QUICKSIGHT`, the only current valid value.
     */
    @JvmName("mbcolesyubbvjygy")
    public suspend fun identityStore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityStore = mapped
    }

    /**
     * @param value Name of the namespace.
     * The following arguments are optional:
     */
    @JvmName("jaafpogvlppvvllw")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtrqjptgaqpbnvps")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xkepgasestkhxewi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("qkunojecpfxefqjf")
    public suspend fun timeouts(`value`: NamespaceTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("sajiortexpdvpsal")
    public suspend fun timeouts(argument: suspend NamespaceTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = NamespaceTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): NamespaceArgs = NamespaceArgs(
        awsAccountId = awsAccountId,
        identityStore = identityStore,
        namespace = namespace,
        tags = tags,
        timeouts = timeouts,
    )
}
