@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleSchedule
import com.pulumi.aws.quicksight.kotlin.outputs.RefreshScheduleSchedule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [RefreshSchedule].
 */
@PulumiTagMarker
public class RefreshScheduleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RefreshScheduleArgs = RefreshScheduleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RefreshScheduleArgsBuilder.() -> Unit) {
        val builder = RefreshScheduleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): RefreshSchedule {
        val builtJavaResource = com.pulumi.aws.quicksight.RefreshSchedule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return RefreshSchedule(builtJavaResource)
    }
}

/**
 * Resource for managing a QuickSight Refresh Schedule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "FULL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "HOURLY",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "FULL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "HOURLY",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "FULL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "HOURLY",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("FULL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval: pulumi.String("HOURLY"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("FULL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("HOURLY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: FULL_REFRESH
 *         scheduleFrequency:
 *           interval: HOURLY
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Weekly Refresh
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "INCREMENTAL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "WEEKLY",
 *             timeOfTheDay: "01:00",
 *             timezone: "Europe/London",
 *             refreshOnDay: {
 *                 dayOfWeek: "MONDAY",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "INCREMENTAL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "WEEKLY",
 *             "time_of_the_day": "01:00",
 *             "timezone": "Europe/London",
 *             "refresh_on_day": {
 *                 "day_of_week": "MONDAY",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "INCREMENTAL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "WEEKLY",
 *                 TimeOfTheDay = "01:00",
 *                 Timezone = "Europe/London",
 *                 RefreshOnDay = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs
 *                 {
 *                     DayOfWeek = "MONDAY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("INCREMENTAL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval:     pulumi.String("WEEKLY"),
 * 					TimeOfTheDay: pulumi.String("01:00"),
 * 					Timezone:     pulumi.String("Europe/London"),
 * 					RefreshOnDay: &quicksight.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs{
 * 						DayOfWeek: pulumi.String("MONDAY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("WEEKLY")
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfWeek("MONDAY")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: INCREMENTAL_REFRESH
 *         scheduleFrequency:
 *           interval: WEEKLY
 *           timeOfTheDay: 01:00
 *           timezone: Europe/London
 *           refreshOnDay:
 *             dayOfWeek: MONDAY
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Monthly Refresh
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "INCREMENTAL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "MONTHLY",
 *             timeOfTheDay: "01:00",
 *             timezone: "Europe/London",
 *             refreshOnDay: {
 *                 dayOfMonth: "1",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "INCREMENTAL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "MONTHLY",
 *             "time_of_the_day": "01:00",
 *             "timezone": "Europe/London",
 *             "refresh_on_day": {
 *                 "day_of_month": "1",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "INCREMENTAL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "MONTHLY",
 *                 TimeOfTheDay = "01:00",
 *                 Timezone = "Europe/London",
 *                 RefreshOnDay = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs
 *                 {
 *                     DayOfMonth = "1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("INCREMENTAL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval:     pulumi.String("MONTHLY"),
 * 					TimeOfTheDay: pulumi.String("01:00"),
 * 					Timezone:     pulumi.String("Europe/London"),
 * 					RefreshOnDay: &quicksight.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs{
 * 						DayOfMonth: pulumi.String("1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("MONTHLY")
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfMonth("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: INCREMENTAL_REFRESH
 *         scheduleFrequency:
 *           interval: MONTHLY
 *           timeOfTheDay: 01:00
 *           timezone: Europe/London
 *           refreshOnDay:
 *             dayOfMonth: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Refresh Schedule using the AWS account ID, data set ID and schedule ID separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/refreshSchedule:RefreshSchedule example 123456789012,dataset-id,schedule-id
 * ```
 */
public class RefreshSchedule internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.RefreshSchedule,
) : KotlinCustomResource(javaResource, RefreshScheduleMapper) {
    /**
     * Amazon Resource Name (ARN) of the refresh schedule.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * The ID of the dataset.
     */
    public val dataSetId: Output<String>
        get() = javaResource.dataSetId().applyValue({ args0 -> args0 })

    /**
     * The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    public val schedule: Output<RefreshScheduleSchedule>?
        get() = javaResource.schedule().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the refresh schedule.
     */
    public val scheduleId: Output<String>
        get() = javaResource.scheduleId().applyValue({ args0 -> args0 })
}

public object RefreshScheduleMapper : ResourceMapper<RefreshSchedule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.RefreshSchedule::class == javaResource::class

    override fun map(javaResource: Resource): RefreshSchedule = RefreshSchedule(
        javaResource as
            com.pulumi.aws.quicksight.RefreshSchedule,
    )
}

/**
 * @see [RefreshSchedule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [RefreshSchedule].
 */
public suspend fun refreshSchedule(
    name: String,
    block: suspend RefreshScheduleResourceBuilder.() -> Unit,
): RefreshSchedule {
    val builder = RefreshScheduleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [RefreshSchedule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun refreshSchedule(name: String): RefreshSchedule {
    val builder = RefreshScheduleResourceBuilder()
    builder.name(name)
    return builder.build()
}
