@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.RefreshScheduleArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.RefreshScheduleScheduleArgs
import com.pulumi.aws.quicksight.kotlin.inputs.RefreshScheduleScheduleArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Refresh Schedule.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "FULL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "HOURLY",
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "FULL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "HOURLY",
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "FULL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "HOURLY",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("FULL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval: pulumi.String("HOURLY"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("FULL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("HOURLY")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: FULL_REFRESH
 *         scheduleFrequency:
 *           interval: HOURLY
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Weekly Refresh
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "INCREMENTAL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "WEEKLY",
 *             timeOfTheDay: "01:00",
 *             timezone: "Europe/London",
 *             refreshOnDay: {
 *                 dayOfWeek: "MONDAY",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "INCREMENTAL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "WEEKLY",
 *             "time_of_the_day": "01:00",
 *             "timezone": "Europe/London",
 *             "refresh_on_day": {
 *                 "day_of_week": "MONDAY",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "INCREMENTAL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "WEEKLY",
 *                 TimeOfTheDay = "01:00",
 *                 Timezone = "Europe/London",
 *                 RefreshOnDay = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs
 *                 {
 *                     DayOfWeek = "MONDAY",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("INCREMENTAL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval:     pulumi.String("WEEKLY"),
 * 					TimeOfTheDay: pulumi.String("01:00"),
 * 					Timezone:     pulumi.String("Europe/London"),
 * 					RefreshOnDay: &quicksight.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs{
 * 						DayOfWeek: pulumi.String("MONDAY"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("WEEKLY")
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfWeek("MONDAY")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: INCREMENTAL_REFRESH
 *         scheduleFrequency:
 *           interval: WEEKLY
 *           timeOfTheDay: 01:00
 *           timezone: Europe/London
 *           refreshOnDay:
 *             dayOfWeek: MONDAY
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Monthly Refresh
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.RefreshSchedule("example", {
 *     dataSetId: "dataset-id",
 *     scheduleId: "schedule-id",
 *     schedule: {
 *         refreshType: "INCREMENTAL_REFRESH",
 *         scheduleFrequency: {
 *             interval: "MONTHLY",
 *             timeOfTheDay: "01:00",
 *             timezone: "Europe/London",
 *             refreshOnDay: {
 *                 dayOfMonth: "1",
 *             },
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.RefreshSchedule("example",
 *     data_set_id="dataset-id",
 *     schedule_id="schedule-id",
 *     schedule={
 *         "refresh_type": "INCREMENTAL_REFRESH",
 *         "schedule_frequency": {
 *             "interval": "MONTHLY",
 *             "time_of_the_day": "01:00",
 *             "timezone": "Europe/London",
 *             "refresh_on_day": {
 *                 "day_of_month": "1",
 *             },
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.RefreshSchedule("example", new()
 *     {
 *         DataSetId = "dataset-id",
 *         ScheduleId = "schedule-id",
 *         Schedule = new Aws.Quicksight.Inputs.RefreshScheduleScheduleArgs
 *         {
 *             RefreshType = "INCREMENTAL_REFRESH",
 *             ScheduleFrequency = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyArgs
 *             {
 *                 Interval = "MONTHLY",
 *                 TimeOfTheDay = "01:00",
 *                 Timezone = "Europe/London",
 *                 RefreshOnDay = new Aws.Quicksight.Inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs
 *                 {
 *                     DayOfMonth = "1",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewRefreshSchedule(ctx, "example", &quicksight.RefreshScheduleArgs{
 * 			DataSetId:  pulumi.String("dataset-id"),
 * 			ScheduleId: pulumi.String("schedule-id"),
 * 			Schedule: &quicksight.RefreshScheduleScheduleArgs{
 * 				RefreshType: pulumi.String("INCREMENTAL_REFRESH"),
 * 				ScheduleFrequency: &quicksight.RefreshScheduleScheduleScheduleFrequencyArgs{
 * 					Interval:     pulumi.String("MONTHLY"),
 * 					TimeOfTheDay: pulumi.String("01:00"),
 * 					Timezone:     pulumi.String("Europe/London"),
 * 					RefreshOnDay: &quicksight.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs{
 * 						DayOfMonth: pulumi.String("1"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.RefreshSchedule;
 * import com.pulumi.aws.quicksight.RefreshScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyArgs;
 * import com.pulumi.aws.quicksight.inputs.RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new RefreshSchedule("example", RefreshScheduleArgs.builder()
 *             .dataSetId("dataset-id")
 *             .scheduleId("schedule-id")
 *             .schedule(RefreshScheduleScheduleArgs.builder()
 *                 .refreshType("INCREMENTAL_REFRESH")
 *                 .scheduleFrequency(RefreshScheduleScheduleScheduleFrequencyArgs.builder()
 *                     .interval("MONTHLY")
 *                     .timeOfTheDay("01:00")
 *                     .timezone("Europe/London")
 *                     .refreshOnDay(RefreshScheduleScheduleScheduleFrequencyRefreshOnDayArgs.builder()
 *                         .dayOfMonth("1")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:RefreshSchedule
 *     properties:
 *       dataSetId: dataset-id
 *       scheduleId: schedule-id
 *       schedule:
 *         refreshType: INCREMENTAL_REFRESH
 *         scheduleFrequency:
 *           interval: MONTHLY
 *           timeOfTheDay: 01:00
 *           timezone: Europe/London
 *           refreshOnDay:
 *             dayOfMonth: '1'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Refresh Schedule using the AWS account ID, data set ID and schedule ID separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/refreshSchedule:RefreshSchedule example 123456789012,dataset-id,schedule-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property dataSetId The ID of the dataset.
 * @property schedule The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
 * The following arguments are optional:
 * @property scheduleId The ID of the refresh schedule.
 */
public data class RefreshScheduleArgs(
    public val awsAccountId: Output<String>? = null,
    public val dataSetId: Output<String>? = null,
    public val schedule: Output<RefreshScheduleScheduleArgs>? = null,
    public val scheduleId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.RefreshScheduleArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.RefreshScheduleArgs =
        com.pulumi.aws.quicksight.RefreshScheduleArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dataSetId(dataSetId?.applyValue({ args0 -> args0 }))
            .schedule(schedule?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .scheduleId(scheduleId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RefreshScheduleArgs].
 */
@PulumiTagMarker
public class RefreshScheduleArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dataSetId: Output<String>? = null

    private var schedule: Output<RefreshScheduleScheduleArgs>? = null

    private var scheduleId: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("xprgclbyodatswpw")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The ID of the dataset.
     */
    @JvmName("logcughvsyhvslgj")
    public suspend fun dataSetId(`value`: Output<String>) {
        this.dataSetId = value
    }

    /**
     * @param value The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("eyuheehxsldftgjb")
    public suspend fun schedule(`value`: Output<RefreshScheduleScheduleArgs>) {
        this.schedule = value
    }

    /**
     * @param value The ID of the refresh schedule.
     */
    @JvmName("iincsfuceefiiquh")
    public suspend fun scheduleId(`value`: Output<String>) {
        this.scheduleId = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("qgqrpwbiqbuchnom")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The ID of the dataset.
     */
    @JvmName("gkesxaxvyurxpctj")
    public suspend fun dataSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataSetId = mapped
    }

    /**
     * @param value The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("vgqiijrspeignbmg")
    public suspend fun schedule(`value`: RefreshScheduleScheduleArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schedule = mapped
    }

    /**
     * @param argument The [refresh schedule](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RefreshSchedule.html). See schedule
     * The following arguments are optional:
     */
    @JvmName("oxhptqhtpobolvdo")
    public suspend fun schedule(argument: suspend RefreshScheduleScheduleArgsBuilder.() -> Unit) {
        val toBeMapped = RefreshScheduleScheduleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.schedule = mapped
    }

    /**
     * @param value The ID of the refresh schedule.
     */
    @JvmName("dhcnmwrcnvwmkwal")
    public suspend fun scheduleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleId = mapped
    }

    internal fun build(): RefreshScheduleArgs = RefreshScheduleArgs(
        awsAccountId = awsAccountId,
        dataSetId = dataSetId,
        schedule = schedule,
        scheduleId = scheduleId,
    )
}
