@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.TemplateArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.TemplatePermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.TemplatePermissionArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.TemplateSourceEntityArgs
import com.pulumi.aws.quicksight.kotlin.inputs.TemplateSourceEntityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Template.
 * ## Example Usage
 * ### From Source Template
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Template("example", {
 *     templateId: "example-id",
 *     name: "example-name",
 *     versionDescription: "version",
 *     sourceEntity: {
 *         sourceTemplate: {
 *             arn: source.arn,
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Template("example",
 *     template_id="example-id",
 *     name="example-name",
 *     version_description="version",
 *     source_entity={
 *         "source_template": {
 *             "arn": source["arn"],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Template("example", new()
 *     {
 *         TemplateId = "example-id",
 *         Name = "example-name",
 *         VersionDescription = "version",
 *         SourceEntity = new Aws.Quicksight.Inputs.TemplateSourceEntityArgs
 *         {
 *             SourceTemplate = new Aws.Quicksight.Inputs.TemplateSourceEntitySourceTemplateArgs
 *             {
 *                 Arn = source.Arn,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewTemplate(ctx, "example", &quicksight.TemplateArgs{
 * 			TemplateId:         pulumi.String("example-id"),
 * 			Name:               pulumi.String("example-name"),
 * 			VersionDescription: pulumi.String("version"),
 * 			SourceEntity: &quicksight.TemplateSourceEntityArgs{
 * 				SourceTemplate: &quicksight.TemplateSourceEntitySourceTemplateArgs{
 * 					Arn: pulumi.Any(source.Arn),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Template;
 * import com.pulumi.aws.quicksight.TemplateArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntityArgs;
 * import com.pulumi.aws.quicksight.inputs.TemplateSourceEntitySourceTemplateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Template("example", TemplateArgs.builder()
 *             .templateId("example-id")
 *             .name("example-name")
 *             .versionDescription("version")
 *             .sourceEntity(TemplateSourceEntityArgs.builder()
 *                 .sourceTemplate(TemplateSourceEntitySourceTemplateArgs.builder()
 *                     .arn(source.arn())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Template
 *     properties:
 *       templateId: example-id
 *       name: example-name
 *       versionDescription: version
 *       sourceEntity:
 *         sourceTemplate:
 *           arn: ${source.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ### With Definition
 * <!--Start PulumiCodeChooser -->
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Template
 *     properties:
 *       templateId: example-id
 *       name: example-name
 *       versionDescription: version
 *       definition:
 *         dataSetConfigurations:
 *           - dataSetSchema:
 *               columnSchemaLists:
 *                 - name: Column1
 *                   dataType: STRING
 *                 - name: Column2
 *                   dataType: INTEGER
 *             placeholder: '1'
 *         sheets:
 *           - title: Test
 *             sheetId: Test1
 *             visuals:
 *               - barChartVisual:
 *                   visualId: BarChart
 *                   chartConfiguration:
 *                     fieldWells:
 *                       barChartAggregatedFieldWells:
 *                         categories:
 *                           - categoricalDimensionField:
 *                               fieldId: '1'
 *                               column:
 *                                 columnName: Column1
 *                                 dataSetIdentifier: '1'
 *                         values:
 *                           - numericalMeasureField:
 *                               fieldId: '2'
 *                               column:
 *                                 columnName: Column2
 *                                 dataSetIdentifier: '1'
 *                               aggregationFunction:
 *                                 simpleNumericalAggregation: SUM
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Template using the AWS account ID and template ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/template:Template example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property name Display name for the template.
 * @property permissions A set of resource permissions on the template. Maximum of 64 items. See permissions.
 * @property sourceEntity The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property templateId Identifier for the template.
 * @property versionDescription A description of the current template version being created/updated.
 * The following arguments are optional:
 */
public data class TemplateArgs(
    public val awsAccountId: Output<String>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<List<TemplatePermissionArgs>>? = null,
    public val sourceEntity: Output<TemplateSourceEntityArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateId: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.TemplateArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.TemplateArgs =
        com.pulumi.aws.quicksight.TemplateArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .sourceEntity(sourceEntity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateId(templateId?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateArgs].
 */
@PulumiTagMarker
public class TemplateArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var name: Output<String>? = null

    private var permissions: Output<List<TemplatePermissionArgs>>? = null

    private var sourceEntity: Output<TemplateSourceEntityArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateId: Output<String>? = null

    private var versionDescription: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("nlsmltoexniepijy")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value Display name for the template.
     */
    @JvmName("pgfsssnwiltljfoa")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("neqlhujvewfwlqdu")
    public suspend fun permissions(`value`: Output<List<TemplatePermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("qjeuwrfaihyuesml")
    public suspend fun permissions(vararg values: Output<TemplatePermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("onfeyyjvwnwatliq")
    public suspend fun permissions(values: List<Output<TemplatePermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("inpjjpvjocighpal")
    public suspend fun sourceEntity(`value`: Output<TemplateSourceEntityArgs>) {
        this.sourceEntity = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kfhmvnckwlfgmlee")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier for the template.
     */
    @JvmName("eyvdpgorxlgdmfxj")
    public suspend fun templateId(`value`: Output<String>) {
        this.templateId = value
    }

    /**
     * @param value A description of the current template version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("tcschqdhylsuwura")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("wskoerxonwrkplwo")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value Display name for the template.
     */
    @JvmName("vpdhdojmxgqpatvg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("pryvutkxivymeifa")
    public suspend fun permissions(`value`: List<TemplatePermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("pisoufkonpnrobyi")
    public suspend fun permissions(argument: List<suspend TemplatePermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            TemplatePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("cmxxaydetbeocjbu")
    public suspend fun permissions(vararg argument: suspend TemplatePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            TemplatePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("cmerubqadxpqfshf")
    public suspend fun permissions(argument: suspend TemplatePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TemplatePermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the template. Maximum of 64 items. See permissions.
     */
    @JvmName("jtxdlxwdufghxurt")
    public suspend fun permissions(vararg values: TemplatePermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("wojwwshskbrwmsaf")
    public suspend fun sourceEntity(`value`: TemplateSourceEntityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceEntity = mapped
    }

    /**
     * @param argument The entity that you are using as a source when you create the template (analysis or template). Only one of `definition` or `source_entity` should be configured. See source_entity.
     */
    @JvmName("nrrjumcqkxuyfcvq")
    public suspend fun sourceEntity(argument: suspend TemplateSourceEntityArgsBuilder.() -> Unit) {
        val toBeMapped = TemplateSourceEntityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceEntity = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pfbxunhtndymwvve")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xhppxujieeircfhn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier for the template.
     */
    @JvmName("oprxaunpypltvajj")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateId = mapped
    }

    /**
     * @param value A description of the current template version being created/updated.
     * The following arguments are optional:
     */
    @JvmName("wnblhunrthhrjbpj")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    internal fun build(): TemplateArgs = TemplateArgs(
        awsAccountId = awsAccountId,
        name = name,
        permissions = permissions,
        sourceEntity = sourceEntity,
        tags = tags,
        templateId = templateId,
        versionDescription = versionDescription,
    )
}
