@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.ThemeArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.ThemeConfigurationArgs
import com.pulumi.aws.quicksight.kotlin.inputs.ThemeConfigurationArgsBuilder
import com.pulumi.aws.quicksight.kotlin.inputs.ThemePermissionArgs
import com.pulumi.aws.quicksight.kotlin.inputs.ThemePermissionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing a QuickSight Theme.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.quicksight.Theme("example", {
 *     themeId: "example",
 *     name: "example",
 *     baseThemeId: "MIDNIGHT",
 *     configuration: {
 *         dataColorPalette: {
 *             colors: [
 *                 "#FFFFFF",
 *                 "#111111",
 *                 "#222222",
 *                 "#333333",
 *                 "#444444",
 *                 "#555555",
 *                 "#666666",
 *                 "#777777",
 *                 "#888888",
 *                 "#999999",
 *             ],
 *             emptyFillColor: "#FFFFFF",
 *             minMaxGradients: [
 *                 "#FFFFFF",
 *                 "#111111",
 *             ],
 *         },
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.quicksight.Theme("example",
 *     theme_id="example",
 *     name="example",
 *     base_theme_id="MIDNIGHT",
 *     configuration={
 *         "data_color_palette": {
 *             "colors": [
 *                 "#FFFFFF",
 *                 "#111111",
 *                 "#222222",
 *                 "#333333",
 *                 "#444444",
 *                 "#555555",
 *                 "#666666",
 *                 "#777777",
 *                 "#888888",
 *                 "#999999",
 *             ],
 *             "empty_fill_color": "#FFFFFF",
 *             "min_max_gradients": [
 *                 "#FFFFFF",
 *                 "#111111",
 *             ],
 *         },
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Quicksight.Theme("example", new()
 *     {
 *         ThemeId = "example",
 *         Name = "example",
 *         BaseThemeId = "MIDNIGHT",
 *         Configuration = new Aws.Quicksight.Inputs.ThemeConfigurationArgs
 *         {
 *             DataColorPalette = new Aws.Quicksight.Inputs.ThemeConfigurationDataColorPaletteArgs
 *             {
 *                 Colors = new[]
 *                 {
 *                     "#FFFFFF",
 *                     "#111111",
 *                     "#222222",
 *                     "#333333",
 *                     "#444444",
 *                     "#555555",
 *                     "#666666",
 *                     "#777777",
 *                     "#888888",
 *                     "#999999",
 *                 },
 *                 EmptyFillColor = "#FFFFFF",
 *                 MinMaxGradients = new[]
 *                 {
 *                     "#FFFFFF",
 *                     "#111111",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := quicksight.NewTheme(ctx, "example", &quicksight.ThemeArgs{
 * 			ThemeId:     pulumi.String("example"),
 * 			Name:        pulumi.String("example"),
 * 			BaseThemeId: pulumi.String("MIDNIGHT"),
 * 			Configuration: &quicksight.ThemeConfigurationArgs{
 * 				DataColorPalette: &quicksight.ThemeConfigurationDataColorPaletteArgs{
 * 					Colors: pulumi.StringArray{
 * 						pulumi.String("#FFFFFF"),
 * 						pulumi.String("#111111"),
 * 						pulumi.String("#222222"),
 * 						pulumi.String("#333333"),
 * 						pulumi.String("#444444"),
 * 						pulumi.String("#555555"),
 * 						pulumi.String("#666666"),
 * 						pulumi.String("#777777"),
 * 						pulumi.String("#888888"),
 * 						pulumi.String("#999999"),
 * 					},
 * 					EmptyFillColor: pulumi.String("#FFFFFF"),
 * 					MinMaxGradients: pulumi.StringArray{
 * 						pulumi.String("#FFFFFF"),
 * 						pulumi.String("#111111"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.quicksight.Theme;
 * import com.pulumi.aws.quicksight.ThemeArgs;
 * import com.pulumi.aws.quicksight.inputs.ThemeConfigurationArgs;
 * import com.pulumi.aws.quicksight.inputs.ThemeConfigurationDataColorPaletteArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Theme("example", ThemeArgs.builder()
 *             .themeId("example")
 *             .name("example")
 *             .baseThemeId("MIDNIGHT")
 *             .configuration(ThemeConfigurationArgs.builder()
 *                 .dataColorPalette(ThemeConfigurationDataColorPaletteArgs.builder()
 *                     .colors(
 *                         "#FFFFFF",
 *                         "#111111",
 *                         "#222222",
 *                         "#333333",
 *                         "#444444",
 *                         "#555555",
 *                         "#666666",
 *                         "#777777",
 *                         "#888888",
 *                         "#999999")
 *                     .emptyFillColor("#FFFFFF")
 *                     .minMaxGradients(
 *                         "#FFFFFF",
 *                         "#111111")
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:quicksight:Theme
 *     properties:
 *       themeId: example
 *       name: example
 *       baseThemeId: MIDNIGHT
 *       configuration:
 *         dataColorPalette:
 *           colors:
 *             - '#FFFFFF'
 *             - '#111111'
 *             - '#222222'
 *             - '#333333'
 *             - '#444444'
 *             - '#555555'
 *             - '#666666'
 *             - '#777777'
 *             - '#888888'
 *             - '#999999'
 *           emptyFillColor: '#FFFFFF'
 *           minMaxGradients:
 *             - '#FFFFFF'
 *             - '#111111'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import a QuickSight Theme using the AWS account ID and theme ID separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/theme:Theme example 123456789012,example-id
 * ```
 * @property awsAccountId AWS account ID.
 * @property baseThemeId The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
 * @property configuration The theme configuration, which contains the theme display properties. See configuration.
 * The following arguments are optional:
 * @property name Display name of the theme.
 * @property permissions A set of resource permissions on the theme. Maximum of 64 items. See permissions.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property themeId Identifier of the theme.
 * @property versionDescription A description of the current theme version being created/updated.
 */
public data class ThemeArgs(
    public val awsAccountId: Output<String>? = null,
    public val baseThemeId: Output<String>? = null,
    public val configuration: Output<ThemeConfigurationArgs>? = null,
    public val name: Output<String>? = null,
    public val permissions: Output<List<ThemePermissionArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val themeId: Output<String>? = null,
    public val versionDescription: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.ThemeArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.ThemeArgs =
        com.pulumi.aws.quicksight.ThemeArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .baseThemeId(baseThemeId?.applyValue({ args0 -> args0 }))
            .configuration(configuration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .permissions(
                permissions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .themeId(themeId?.applyValue({ args0 -> args0 }))
            .versionDescription(versionDescription?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ThemeArgs].
 */
@PulumiTagMarker
public class ThemeArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var baseThemeId: Output<String>? = null

    private var configuration: Output<ThemeConfigurationArgs>? = null

    private var name: Output<String>? = null

    private var permissions: Output<List<ThemePermissionArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var themeId: Output<String>? = null

    private var versionDescription: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("hjejawopdrvrludg")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
     */
    @JvmName("ujqboqklptvocxyn")
    public suspend fun baseThemeId(`value`: Output<String>) {
        this.baseThemeId = value
    }

    /**
     * @param value The theme configuration, which contains the theme display properties. See configuration.
     * The following arguments are optional:
     */
    @JvmName("xhmcbkxrsctrdbea")
    public suspend fun configuration(`value`: Output<ThemeConfigurationArgs>) {
        this.configuration = value
    }

    /**
     * @param value Display name of the theme.
     */
    @JvmName("libqxnkerumfohhc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("khhbcdiyyigmdqjf")
    public suspend fun permissions(`value`: Output<List<ThemePermissionArgs>>) {
        this.permissions = value
    }

    @JvmName("crcqqoyulvjoytvu")
    public suspend fun permissions(vararg values: Output<ThemePermissionArgs>) {
        this.permissions = Output.all(values.asList())
    }

    /**
     * @param values A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("bqibmvcbtxdyagkm")
    public suspend fun permissions(values: List<Output<ThemePermissionArgs>>) {
        this.permissions = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cjhvtvuixjlxyvwf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Identifier of the theme.
     */
    @JvmName("ljqgyalauqmmxwcj")
    public suspend fun themeId(`value`: Output<String>) {
        this.themeId = value
    }

    /**
     * @param value A description of the current theme version being created/updated.
     */
    @JvmName("mipngcgjbysbykep")
    public suspend fun versionDescription(`value`: Output<String>) {
        this.versionDescription = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("aukcmydkobetkdfy")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value The ID of the theme that a custom theme will inherit from. All themes inherit from one of the starting themes defined by Amazon QuickSight. For a list of the starting themes, use ListThemes or choose Themes from within an analysis.
     */
    @JvmName("iwtxisjkhchxprxh")
    public suspend fun baseThemeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.baseThemeId = mapped
    }

    /**
     * @param value The theme configuration, which contains the theme display properties. See configuration.
     * The following arguments are optional:
     */
    @JvmName("jwfejayclnprwnnv")
    public suspend fun configuration(`value`: ThemeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.configuration = mapped
    }

    /**
     * @param argument The theme configuration, which contains the theme display properties. See configuration.
     * The following arguments are optional:
     */
    @JvmName("dxnmxfawykkpnjum")
    public suspend fun configuration(argument: suspend ThemeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ThemeConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.configuration = mapped
    }

    /**
     * @param value Display name of the theme.
     */
    @JvmName("bdyyexdobktjkmgd")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("fdblnjycmgjbtelv")
    public suspend fun permissions(`value`: List<ThemePermissionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("xjsqselmcdcdytkg")
    public suspend fun permissions(argument: List<suspend ThemePermissionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ThemePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("cugfbjijmmgdilmc")
    public suspend fun permissions(vararg argument: suspend ThemePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ThemePermissionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param argument A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("wqtvtgcttikqhlhl")
    public suspend fun permissions(argument: suspend ThemePermissionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ThemePermissionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.permissions = mapped
    }

    /**
     * @param values A set of resource permissions on the theme. Maximum of 64 items. See permissions.
     */
    @JvmName("vhhreooohkrcvknv")
    public suspend fun permissions(vararg values: ThemePermissionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.permissions = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xcoxvqngkvfeoffc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jgmkyxjeuhyvpvgo")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Identifier of the theme.
     */
    @JvmName("vfyjxdnapyhxtkwj")
    public suspend fun themeId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.themeId = mapped
    }

    /**
     * @param value A description of the current theme version being created/updated.
     */
    @JvmName("iacbjdqftetcanvl")
    public suspend fun versionDescription(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionDescription = mapped
    }

    internal fun build(): ThemeArgs = ThemeArgs(
        awsAccountId = awsAccountId,
        baseThemeId = baseThemeId,
        configuration = configuration,
        name = name,
        permissions = permissions,
        tags = tags,
        themeId = themeId,
        versionDescription = versionDescription,
    )
}
