@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.kotlin.outputs.VpcConnectionTimeouts
import com.pulumi.aws.quicksight.kotlin.outputs.VpcConnectionTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcConnection].
 */
@PulumiTagMarker
public class VpcConnectionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcConnectionArgs = VpcConnectionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcConnectionArgsBuilder.() -> Unit) {
        val builder = VpcConnectionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcConnection {
        val builtJavaResource = com.pulumi.aws.quicksight.VpcConnection(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcConnection(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS QuickSight VPC Connection.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpcConnectionRole = new aws.iam.Role("vpc_connection_role", {
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Action: "sts:AssumeRole",
 *             Principal: {
 *                 Service: "quicksight.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     inlinePolicies: [{
 *         name: "QuickSightVPCConnectionRolePolicy",
 *         policy: JSON.stringify({
 *             Version: "2012-10-17",
 *             Statement: [{
 *                 Effect: "Allow",
 *                 Action: [
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:ModifyNetworkInterfaceAttribute",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                 ],
 *                 Resource: ["*"],
 *             }],
 *         }),
 *     }],
 * });
 * const example = new aws.quicksight.VpcConnection("example", {
 *     vpcConnectionId: "example-connection-id",
 *     name: "Example Connection",
 *     roleArn: vpcConnectionRole.arn,
 *     securityGroupIds: ["sg-00000000000000000"],
 *     subnetIds: [
 *         "subnet-00000000000000000",
 *         "subnet-00000000000000001",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * vpc_connection_role = aws.iam.Role("vpc_connection_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Action": "sts:AssumeRole",
 *             "Principal": {
 *                 "Service": "quicksight.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     inline_policies=[{
 *         "name": "QuickSightVPCConnectionRolePolicy",
 *         "policy": json.dumps({
 *             "version": "2012-10-17",
 *             "statement": [{
 *                 "effect": "Allow",
 *                 "action": [
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:ModifyNetworkInterfaceAttribute",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                 ],
 *                 "resource": ["*"],
 *             }],
 *         }),
 *     }])
 * example = aws.quicksight.VpcConnection("example",
 *     vpc_connection_id="example-connection-id",
 *     name="Example Connection",
 *     role_arn=vpc_connection_role.arn,
 *     security_group_ids=["sg-00000000000000000"],
 *     subnet_ids=[
 *         "subnet-00000000000000000",
 *         "subnet-00000000000000001",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpcConnectionRole = new Aws.Iam.Role("vpc_connection_role", new()
 *     {
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "quicksight.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *         InlinePolicies = new[]
 *         {
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "QuickSightVPCConnectionRolePolicy",
 *                 Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                 {
 *                     ["Version"] = "2012-10-17",
 *                     ["Statement"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["Effect"] = "Allow",
 *                             ["Action"] = new[]
 *                             {
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups",
 *                             },
 *                             ["Resource"] = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                 }),
 *             },
 *         },
 *     });
 *     var example = new Aws.Quicksight.VpcConnection("example", new()
 *     {
 *         VpcConnectionId = "example-connection-id",
 *         Name = "Example Connection",
 *         RoleArn = vpcConnectionRole.Arn,
 *         SecurityGroupIds = new[]
 *         {
 *             "sg-00000000000000000",
 *         },
 *         SubnetIds = new[]
 *         {
 *             "subnet-00000000000000000",
 *             "subnet-00000000000000001",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Action": "sts:AssumeRole",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "quicksight.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Action": []string{
 * 						"ec2:CreateNetworkInterface",
 * 						"ec2:ModifyNetworkInterfaceAttribute",
 * 						"ec2:DeleteNetworkInterface",
 * 						"ec2:DescribeSubnets",
 * 						"ec2:DescribeSecurityGroups",
 * 					},
 * 					"Resource": []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		vpcConnectionRole, err := iam.NewRole(ctx, "vpc_connection_role", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("QuickSightVPCConnectionRolePolicy"),
 * 					Policy: pulumi.String(json1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quicksight.NewVpcConnection(ctx, "example", &quicksight.VpcConnectionArgs{
 * 			VpcConnectionId: pulumi.String("example-connection-id"),
 * 			Name:            pulumi.String("Example Connection"),
 * 			RoleArn:         vpcConnectionRole.Arn,
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				pulumi.String("sg-00000000000000000"),
 * 			},
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-00000000000000000"),
 * 				pulumi.String("subnet-00000000000000001"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.quicksight.VpcConnection;
 * import com.pulumi.aws.quicksight.VpcConnectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpcConnectionRole = new Role("vpcConnectionRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "quicksight.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("QuickSightVPCConnectionRolePolicy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Action", jsonArray(
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups"
 *                             )),
 *                             jsonProperty("Resource", jsonArray("*"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new VpcConnection("example", VpcConnectionArgs.builder()
 *             .vpcConnectionId("example-connection-id")
 *             .name("Example Connection")
 *             .roleArn(vpcConnectionRole.arn())
 *             .securityGroupIds("sg-00000000000000000")
 *             .subnetIds(
 *                 "subnet-00000000000000000",
 *                 "subnet-00000000000000001")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpcConnectionRole:
 *     type: aws:iam:Role
 *     name: vpc_connection_role
 *     properties:
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Action: sts:AssumeRole
 *               Principal:
 *                 Service: quicksight.amazonaws.com
 *       inlinePolicies:
 *         - name: QuickSightVPCConnectionRolePolicy
 *           policy:
 *             fn::toJSON:
 *               Version: 2012-10-17
 *               Statement:
 *                 - Effect: Allow
 *                   Action:
 *                     - ec2:CreateNetworkInterface
 *                     - ec2:ModifyNetworkInterfaceAttribute
 *                     - ec2:DeleteNetworkInterface
 *                     - ec2:DescribeSubnets
 *                     - ec2:DescribeSecurityGroups
 *                   Resource:
 *                     - '*'
 *   example:
 *     type: aws:quicksight:VpcConnection
 *     properties:
 *       vpcConnectionId: example-connection-id
 *       name: Example Connection
 *       roleArn: ${vpcConnectionRole.arn}
 *       securityGroupIds:
 *         - sg-00000000000000000
 *       subnetIds:
 *         - subnet-00000000000000000
 *         - subnet-00000000000000001
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight VPC connection using the AWS account ID and VPC connection ID separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/vpcConnection:VpcConnection example 123456789012,example
 * ```
 */
public class VpcConnection internal constructor(
    override val javaResource: com.pulumi.aws.quicksight.VpcConnection,
) : KotlinCustomResource(javaResource, VpcConnectionMapper) {
    /**
     * ARN of the VPC connection.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The availability status of the VPC connection. Valid values are `AVAILABLE`, `UNAVAILABLE` or `PARTIALLY_AVAILABLE`.
     */
    public val availabilityStatus: Output<String>
        get() = javaResource.availabilityStatus().applyValue({ args0 -> args0 })

    /**
     * AWS account ID.
     */
    public val awsAccountId: Output<String>
        get() = javaResource.awsAccountId().applyValue({ args0 -> args0 })

    /**
     * A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    public val dnsResolvers: Output<List<String>>?
        get() = javaResource.dnsResolvers().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The display name for the VPC connection.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The IAM role to associate with the VPC connection.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * A list of security group IDs for the VPC connection.
     */
    public val securityGroupIds: Output<List<String>>
        get() = javaResource.securityGroupIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>
        get() = javaResource.subnetIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    public val timeouts: Output<VpcConnectionTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The ID of the VPC connection.
     */
    public val vpcConnectionId: Output<String>
        get() = javaResource.vpcConnectionId().applyValue({ args0 -> args0 })
}

public object VpcConnectionMapper : ResourceMapper<VpcConnection> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.quicksight.VpcConnection::class == javaResource::class

    override fun map(javaResource: Resource): VpcConnection = VpcConnection(
        javaResource as
            com.pulumi.aws.quicksight.VpcConnection,
    )
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcConnection].
 */
public suspend fun vpcConnection(
    name: String,
    block: suspend VpcConnectionResourceBuilder.() -> Unit,
): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcConnection].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcConnection(name: String): VpcConnection {
    val builder = VpcConnectionResourceBuilder()
    builder.name(name)
    return builder.build()
}
