@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin

import com.pulumi.aws.quicksight.VpcConnectionArgs.builder
import com.pulumi.aws.quicksight.kotlin.inputs.VpcConnectionTimeoutsArgs
import com.pulumi.aws.quicksight.kotlin.inputs.VpcConnectionTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS QuickSight VPC Connection.
 * ## Example Usage
 * ### Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const vpcConnectionRole = new aws.iam.Role("vpc_connection_role", {
 *     assumeRolePolicy: JSON.stringify({
 *         Version: "2012-10-17",
 *         Statement: [{
 *             Effect: "Allow",
 *             Action: "sts:AssumeRole",
 *             Principal: {
 *                 Service: "quicksight.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     inlinePolicies: [{
 *         name: "QuickSightVPCConnectionRolePolicy",
 *         policy: JSON.stringify({
 *             Version: "2012-10-17",
 *             Statement: [{
 *                 Effect: "Allow",
 *                 Action: [
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:ModifyNetworkInterfaceAttribute",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                 ],
 *                 Resource: ["*"],
 *             }],
 *         }),
 *     }],
 * });
 * const example = new aws.quicksight.VpcConnection("example", {
 *     vpcConnectionId: "example-connection-id",
 *     name: "Example Connection",
 *     roleArn: vpcConnectionRole.arn,
 *     securityGroupIds: ["sg-00000000000000000"],
 *     subnetIds: [
 *         "subnet-00000000000000000",
 *         "subnet-00000000000000001",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * vpc_connection_role = aws.iam.Role("vpc_connection_role",
 *     assume_role_policy=json.dumps({
 *         "Version": "2012-10-17",
 *         "Statement": [{
 *             "Effect": "Allow",
 *             "Action": "sts:AssumeRole",
 *             "Principal": {
 *                 "Service": "quicksight.amazonaws.com",
 *             },
 *         }],
 *     }),
 *     inline_policies=[{
 *         "name": "QuickSightVPCConnectionRolePolicy",
 *         "policy": json.dumps({
 *             "version": "2012-10-17",
 *             "statement": [{
 *                 "effect": "Allow",
 *                 "action": [
 *                     "ec2:CreateNetworkInterface",
 *                     "ec2:ModifyNetworkInterfaceAttribute",
 *                     "ec2:DeleteNetworkInterface",
 *                     "ec2:DescribeSubnets",
 *                     "ec2:DescribeSecurityGroups",
 *                 ],
 *                 "resource": ["*"],
 *             }],
 *         }),
 *     }])
 * example = aws.quicksight.VpcConnection("example",
 *     vpc_connection_id="example-connection-id",
 *     name="Example Connection",
 *     role_arn=vpc_connection_role.arn,
 *     security_group_ids=["sg-00000000000000000"],
 *     subnet_ids=[
 *         "subnet-00000000000000000",
 *         "subnet-00000000000000001",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var vpcConnectionRole = new Aws.Iam.Role("vpc_connection_role", new()
 *     {
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Version"] = "2012-10-17",
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Effect"] = "Allow",
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "quicksight.amazonaws.com",
 *                     },
 *                 },
 *             },
 *         }),
 *         InlinePolicies = new[]
 *         {
 *             new Aws.Iam.Inputs.RoleInlinePolicyArgs
 *             {
 *                 Name = "QuickSightVPCConnectionRolePolicy",
 *                 Policy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *                 {
 *                     ["Version"] = "2012-10-17",
 *                     ["Statement"] = new[]
 *                     {
 *                         new Dictionary<string, object?>
 *                         {
 *                             ["Effect"] = "Allow",
 *                             ["Action"] = new[]
 *                             {
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups",
 *                             },
 *                             ["Resource"] = new[]
 *                             {
 *                                 "*",
 *                             },
 *                         },
 *                     },
 *                 }),
 *             },
 *         },
 *     });
 *     var example = new Aws.Quicksight.VpcConnection("example", new()
 *     {
 *         VpcConnectionId = "example-connection-id",
 *         Name = "Example Connection",
 *         RoleArn = vpcConnectionRole.Arn,
 *         SecurityGroupIds = new[]
 *         {
 *             "sg-00000000000000000",
 *         },
 *         SubnetIds = new[]
 *         {
 *             "subnet-00000000000000000",
 *             "subnet-00000000000000001",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/quicksight"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Action": "sts:AssumeRole",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "quicksight.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		tmpJSON1, err := json.Marshal(map[string]interface{}{
 * 			"Version": "2012-10-17",
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Effect": "Allow",
 * 					"Action": []string{
 * 						"ec2:CreateNetworkInterface",
 * 						"ec2:ModifyNetworkInterfaceAttribute",
 * 						"ec2:DeleteNetworkInterface",
 * 						"ec2:DescribeSubnets",
 * 						"ec2:DescribeSecurityGroups",
 * 					},
 * 					"Resource": []string{
 * 						"*",
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json1 := string(tmpJSON1)
 * 		vpcConnectionRole, err := iam.NewRole(ctx, "vpc_connection_role", &iam.RoleArgs{
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 			InlinePolicies: iam.RoleInlinePolicyArray{
 * 				&iam.RoleInlinePolicyArgs{
 * 					Name:   pulumi.String("QuickSightVPCConnectionRolePolicy"),
 * 					Policy: pulumi.String(json1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = quicksight.NewVpcConnection(ctx, "example", &quicksight.VpcConnectionArgs{
 * 			VpcConnectionId: pulumi.String("example-connection-id"),
 * 			Name:            pulumi.String("Example Connection"),
 * 			RoleArn:         vpcConnectionRole.Arn,
 * 			SecurityGroupIds: pulumi.StringArray{
 * 				pulumi.String("sg-00000000000000000"),
 * 			},
 * 			SubnetIds: pulumi.StringArray{
 * 				pulumi.String("subnet-00000000000000000"),
 * 				pulumi.String("subnet-00000000000000001"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.inputs.RoleInlinePolicyArgs;
 * import com.pulumi.aws.quicksight.VpcConnection;
 * import com.pulumi.aws.quicksight.VpcConnectionArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var vpcConnectionRole = new Role("vpcConnectionRole", RoleArgs.builder()
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Version", "2012-10-17"),
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "quicksight.amazonaws.com")
 *                         ))
 *                     )))
 *                 )))
 *             .inlinePolicies(RoleInlinePolicyArgs.builder()
 *                 .name("QuickSightVPCConnectionRolePolicy")
 *                 .policy(serializeJson(
 *                     jsonObject(
 *                         jsonProperty("Version", "2012-10-17"),
 *                         jsonProperty("Statement", jsonArray(jsonObject(
 *                             jsonProperty("Effect", "Allow"),
 *                             jsonProperty("Action", jsonArray(
 *                                 "ec2:CreateNetworkInterface",
 *                                 "ec2:ModifyNetworkInterfaceAttribute",
 *                                 "ec2:DeleteNetworkInterface",
 *                                 "ec2:DescribeSubnets",
 *                                 "ec2:DescribeSecurityGroups"
 *                             )),
 *                             jsonProperty("Resource", jsonArray("*"))
 *                         )))
 *                     )))
 *                 .build())
 *             .build());
 *         var example = new VpcConnection("example", VpcConnectionArgs.builder()
 *             .vpcConnectionId("example-connection-id")
 *             .name("Example Connection")
 *             .roleArn(vpcConnectionRole.arn())
 *             .securityGroupIds("sg-00000000000000000")
 *             .subnetIds(
 *                 "subnet-00000000000000000",
 *                 "subnet-00000000000000001")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   vpcConnectionRole:
 *     type: aws:iam:Role
 *     name: vpc_connection_role
 *     properties:
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Version: 2012-10-17
 *           Statement:
 *             - Effect: Allow
 *               Action: sts:AssumeRole
 *               Principal:
 *                 Service: quicksight.amazonaws.com
 *       inlinePolicies:
 *         - name: QuickSightVPCConnectionRolePolicy
 *           policy:
 *             fn::toJSON:
 *               Version: 2012-10-17
 *               Statement:
 *                 - Effect: Allow
 *                   Action:
 *                     - ec2:CreateNetworkInterface
 *                     - ec2:ModifyNetworkInterfaceAttribute
 *                     - ec2:DeleteNetworkInterface
 *                     - ec2:DescribeSubnets
 *                     - ec2:DescribeSecurityGroups
 *                   Resource:
 *                     - '*'
 *   example:
 *     type: aws:quicksight:VpcConnection
 *     properties:
 *       vpcConnectionId: example-connection-id
 *       name: Example Connection
 *       roleArn: ${vpcConnectionRole.arn}
 *       securityGroupIds:
 *         - sg-00000000000000000
 *       subnetIds:
 *         - subnet-00000000000000000
 *         - subnet-00000000000000001
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import QuickSight VPC connection using the AWS account ID and VPC connection ID separated by commas (`,`). For example:
 * ```sh
 * $ pulumi import aws:quicksight/vpcConnection:VpcConnection example 123456789012,example
 * ```
 * @property awsAccountId AWS account ID.
 * @property dnsResolvers A list of IP addresses of DNS resolver endpoints for the VPC connection.
 * @property name The display name for the VPC connection.
 * @property roleArn The IAM role to associate with the VPC connection.
 * @property securityGroupIds A list of security group IDs for the VPC connection.
 * @property subnetIds A list of subnet IDs for the VPC connection.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property timeouts
 * @property vpcConnectionId The ID of the VPC connection.
 */
public data class VpcConnectionArgs(
    public val awsAccountId: Output<String>? = null,
    public val dnsResolvers: Output<List<String>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val timeouts: Output<VpcConnectionTimeoutsArgs>? = null,
    public val vpcConnectionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.VpcConnectionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.VpcConnectionArgs =
        com.pulumi.aws.quicksight.VpcConnectionArgs.builder()
            .awsAccountId(awsAccountId?.applyValue({ args0 -> args0 }))
            .dnsResolvers(dnsResolvers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vpcConnectionId(vpcConnectionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcConnectionArgs].
 */
@PulumiTagMarker
public class VpcConnectionArgsBuilder internal constructor() {
    private var awsAccountId: Output<String>? = null

    private var dnsResolvers: Output<List<String>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var timeouts: Output<VpcConnectionTimeoutsArgs>? = null

    private var vpcConnectionId: Output<String>? = null

    /**
     * @param value AWS account ID.
     */
    @JvmName("ilprnqffyglorlhi")
    public suspend fun awsAccountId(`value`: Output<String>) {
        this.awsAccountId = value
    }

    /**
     * @param value A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("daqklqpcjdbhhwbb")
    public suspend fun dnsResolvers(`value`: Output<List<String>>) {
        this.dnsResolvers = value
    }

    @JvmName("jysrvyydhlltgryg")
    public suspend fun dnsResolvers(vararg values: Output<String>) {
        this.dnsResolvers = Output.all(values.asList())
    }

    /**
     * @param values A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("balmrfmolgeoltnp")
    public suspend fun dnsResolvers(values: List<Output<String>>) {
        this.dnsResolvers = Output.all(values)
    }

    /**
     * @param value The display name for the VPC connection.
     */
    @JvmName("ohgwqwvfndjomolt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The IAM role to associate with the VPC connection.
     */
    @JvmName("nilbilretaqintwh")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value A list of security group IDs for the VPC connection.
     */
    @JvmName("hxfmwrywwiquhlit")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("uoyfiegrhxgjbwuh")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values A list of security group IDs for the VPC connection.
     */
    @JvmName("jotcjkfljsydumnv")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("uwcsixgmvprmlqem")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("ekprtfejcmdacevo")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("gbhdnsbpnxoiefvu")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("efhiduhkmjbwhaup")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value
     */
    @JvmName("quradqwelxtdiwub")
    public suspend fun timeouts(`value`: Output<VpcConnectionTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The ID of the VPC connection.
     */
    @JvmName("ajparenafloraoik")
    public suspend fun vpcConnectionId(`value`: Output<String>) {
        this.vpcConnectionId = value
    }

    /**
     * @param value AWS account ID.
     */
    @JvmName("itekpjqioxgcijpx")
    public suspend fun awsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.awsAccountId = mapped
    }

    /**
     * @param value A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("ccicpgeetpslfjoi")
    public suspend fun dnsResolvers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsResolvers = mapped
    }

    /**
     * @param values A list of IP addresses of DNS resolver endpoints for the VPC connection.
     */
    @JvmName("bwoantaupxkpmuxp")
    public suspend fun dnsResolvers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsResolvers = mapped
    }

    /**
     * @param value The display name for the VPC connection.
     */
    @JvmName("rnwieluopotnnjcl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The IAM role to associate with the VPC connection.
     */
    @JvmName("qntofviiigkterrb")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value A list of security group IDs for the VPC connection.
     */
    @JvmName("aanqlvvwoweqmtwj")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values A list of security group IDs for the VPC connection.
     */
    @JvmName("ujxrffwjwsmrlkll")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("dwpgoitypcwfqcmu")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values A list of subnet IDs for the VPC connection.
     * The following arguments are optional:
     */
    @JvmName("lchbditnfdrdgmvh")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jknycylsgrdwdptc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mfebikfysvinhyce")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value
     */
    @JvmName("xeacefhmtrmomrfr")
    public suspend fun timeouts(`value`: VpcConnectionTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("rmlouuuwwkekboff")
    public suspend fun timeouts(argument: suspend VpcConnectionTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = VpcConnectionTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    /**
     * @param value The ID of the VPC connection.
     */
    @JvmName("hsdpmimbylnkptsy")
    public suspend fun vpcConnectionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConnectionId = mapped
    }

    internal fun build(): VpcConnectionArgs = VpcConnectionArgs(
        awsAccountId = awsAccountId,
        dnsResolvers = dnsResolvers,
        name = name,
        roleArn = roleArn,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
        tags = tags,
        timeouts = timeouts,
        vpcConnectionId = vpcConnectionId,
    )
}
