@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.AnalysisParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dateTimeParameters A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
 * @property decimalParameters A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
 * @property integerParameters A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
 * @property stringParameters A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
 */
public data class AnalysisParametersArgs(
    public val dateTimeParameters: Output<List<AnalysisParametersDateTimeParameterArgs>>? = null,
    public val decimalParameters: Output<List<AnalysisParametersDecimalParameterArgs>>? = null,
    public val integerParameters: Output<List<AnalysisParametersIntegerParameterArgs>>? = null,
    public val stringParameters: Output<List<AnalysisParametersStringParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.AnalysisParametersArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.AnalysisParametersArgs =
        com.pulumi.aws.quicksight.inputs.AnalysisParametersArgs.builder()
            .dateTimeParameters(
                dateTimeParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .decimalParameters(
                decimalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .integerParameters(
                integerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringParameters(
                stringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalysisParametersArgs].
 */
@PulumiTagMarker
public class AnalysisParametersArgsBuilder internal constructor() {
    private var dateTimeParameters: Output<List<AnalysisParametersDateTimeParameterArgs>>? = null

    private var decimalParameters: Output<List<AnalysisParametersDecimalParameterArgs>>? = null

    private var integerParameters: Output<List<AnalysisParametersIntegerParameterArgs>>? = null

    private var stringParameters: Output<List<AnalysisParametersStringParameterArgs>>? = null

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("rymdcuvfycliihsw")
    public suspend fun dateTimeParameters(`value`: Output<List<AnalysisParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = value
    }

    @JvmName("cptuaxgcgsjjrpih")
    public suspend fun dateTimeParameters(vararg values: Output<AnalysisParametersDateTimeParameterArgs>) {
        this.dateTimeParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("wovmpyfshgnngcuv")
    public suspend fun dateTimeParameters(values: List<Output<AnalysisParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("pjqohsvmxwvdfxrx")
    public suspend fun decimalParameters(`value`: Output<List<AnalysisParametersDecimalParameterArgs>>) {
        this.decimalParameters = value
    }

    @JvmName("fjsvcoxsfncjdpyj")
    public suspend fun decimalParameters(vararg values: Output<AnalysisParametersDecimalParameterArgs>) {
        this.decimalParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("qncrommyekknasxe")
    public suspend fun decimalParameters(values: List<Output<AnalysisParametersDecimalParameterArgs>>) {
        this.decimalParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("sashwlheykpdirfu")
    public suspend fun integerParameters(`value`: Output<List<AnalysisParametersIntegerParameterArgs>>) {
        this.integerParameters = value
    }

    @JvmName("ikdlwtipvihnqwfj")
    public suspend fun integerParameters(vararg values: Output<AnalysisParametersIntegerParameterArgs>) {
        this.integerParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("oxgepcuwayrpxrtg")
    public suspend fun integerParameters(values: List<Output<AnalysisParametersIntegerParameterArgs>>) {
        this.integerParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("cmnesvfkvybfuqur")
    public suspend fun stringParameters(`value`: Output<List<AnalysisParametersStringParameterArgs>>) {
        this.stringParameters = value
    }

    @JvmName("ettoarcjdfgovaeu")
    public suspend fun stringParameters(vararg values: Output<AnalysisParametersStringParameterArgs>) {
        this.stringParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("pdrvwyyaepdpykjl")
    public suspend fun stringParameters(values: List<Output<AnalysisParametersStringParameterArgs>>) {
        this.stringParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("mklirnvhvdjnuusv")
    public suspend fun dateTimeParameters(`value`: List<AnalysisParametersDateTimeParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("fbsvxidxrdbetfmv")
    public suspend fun dateTimeParameters(argument: List<suspend AnalysisParametersDateTimeParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("ebpnxtmnypbwttgo")
    public suspend fun dateTimeParameters(vararg argument: suspend AnalysisParametersDateTimeParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("woqadsftqdmrmtoc")
    public suspend fun dateTimeParameters(argument: suspend AnalysisParametersDateTimeParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalysisParametersDateTimeParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("lyleerdgmmgbqogf")
    public suspend fun dateTimeParameters(vararg values: AnalysisParametersDateTimeParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("agnybyknrblyamtr")
    public suspend fun decimalParameters(`value`: List<AnalysisParametersDecimalParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("dljolsqgrirkxjoh")
    public suspend fun decimalParameters(argument: List<suspend AnalysisParametersDecimalParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("qavkmgguggplynol")
    public suspend fun decimalParameters(vararg argument: suspend AnalysisParametersDecimalParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("ijljcxjgvoxjjiky")
    public suspend fun decimalParameters(argument: suspend AnalysisParametersDecimalParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalysisParametersDecimalParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("mkdyuovbacesqqei")
    public suspend fun decimalParameters(vararg values: AnalysisParametersDecimalParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("wrmfjuxpknxupanq")
    public suspend fun integerParameters(`value`: List<AnalysisParametersIntegerParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("gxdpcaiynqcxgipp")
    public suspend fun integerParameters(argument: List<suspend AnalysisParametersIntegerParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("odkffftvlnxtpdud")
    public suspend fun integerParameters(vararg argument: suspend AnalysisParametersIntegerParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("lifxodcevatmjcjb")
    public suspend fun integerParameters(argument: suspend AnalysisParametersIntegerParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalysisParametersIntegerParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("xvaqpxxshmpujawn")
    public suspend fun integerParameters(vararg values: AnalysisParametersIntegerParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("elvpekmivivksebs")
    public suspend fun stringParameters(`value`: List<AnalysisParametersStringParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("eftwurawilycyolf")
    public suspend fun stringParameters(argument: List<suspend AnalysisParametersStringParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("wendhebgudagelpy")
    public suspend fun stringParameters(vararg argument: suspend AnalysisParametersStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalysisParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("ncccrnpfonjglncj")
    public suspend fun stringParameters(argument: suspend AnalysisParametersStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            AnalysisParametersStringParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("bffhexsuyaalewqq")
    public suspend fun stringParameters(vararg values: AnalysisParametersStringParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    internal fun build(): AnalysisParametersArgs = AnalysisParametersArgs(
        dateTimeParameters = dateTimeParameters,
        decimalParameters = decimalParameters,
        integerParameters = integerParameters,
        stringParameters = stringParameters,
    )
}
