@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Amazon Resource Name (ARN) of the resource.
 * @property dataSetReferences List of dataset references. See data_set_references.
 */
public data class AnalysisSourceEntitySourceTemplateArgs(
    public val arn: Output<String>,
    public val dataSetReferences: Output<List<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs =
        com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateArgs.builder()
            .arn(arn.applyValue({ args0 -> args0 }))
            .dataSetReferences(
                dataSetReferences.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AnalysisSourceEntitySourceTemplateArgs].
 */
@PulumiTagMarker
public class AnalysisSourceEntitySourceTemplateArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var dataSetReferences:
        Output<List<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("gueskesqapiymmot")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value List of dataset references. See data_set_references.
     */
    @JvmName("houqqbfhgugbflft")
    public suspend fun dataSetReferences(`value`: Output<List<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>>) {
        this.dataSetReferences = value
    }

    @JvmName("dndhvgvfbfxmjmnj")
    public suspend fun dataSetReferences(vararg values: Output<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>) {
        this.dataSetReferences = Output.all(values.asList())
    }

    /**
     * @param values List of dataset references. See data_set_references.
     */
    @JvmName("nudncynuvfujxihw")
    public suspend fun dataSetReferences(values: List<Output<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>>) {
        this.dataSetReferences = Output.all(values)
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the resource.
     */
    @JvmName("tfitlxbtnbgkyneh")
    public suspend fun arn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value List of dataset references. See data_set_references.
     */
    @JvmName("dowxcsmgrpmtuvyg")
    public suspend fun dataSetReferences(`value`: List<AnalysisSourceEntitySourceTemplateDataSetReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("hjepfsqwnkqfhknt")
    public suspend fun dataSetReferences(argument: List<suspend AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("hdmpsmtnkkkfienj")
    public suspend fun dataSetReferences(vararg argument: suspend AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param argument List of dataset references. See data_set_references.
     */
    @JvmName("fjrrxgucpxqlbpre")
    public suspend fun dataSetReferences(argument: suspend AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.dataSetReferences = mapped
    }

    /**
     * @param values List of dataset references. See data_set_references.
     */
    @JvmName("lokdlgplockpgybh")
    public suspend fun dataSetReferences(vararg values: AnalysisSourceEntitySourceTemplateDataSetReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetReferences = mapped
    }

    internal fun build(): AnalysisSourceEntitySourceTemplateArgs =
        AnalysisSourceEntitySourceTemplateArgs(
            arn = arn ?: throw PulumiNullFieldException("arn"),
            dataSetReferences = dataSetReferences ?: throw PulumiNullFieldException("dataSetReferences"),
        )
}
