@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dataSetArn Dataset Amazon Resource Name (ARN).
 * @property dataSetPlaceholder Dataset placeholder.
 */
public data class AnalysisSourceEntitySourceTemplateDataSetReferenceArgs(
    public val dataSetArn: Output<String>,
    public val dataSetPlaceholder: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs =
        com.pulumi.aws.quicksight.inputs.AnalysisSourceEntitySourceTemplateDataSetReferenceArgs.builder()
            .dataSetArn(dataSetArn.applyValue({ args0 -> args0 }))
            .dataSetPlaceholder(dataSetPlaceholder.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AnalysisSourceEntitySourceTemplateDataSetReferenceArgs].
 */
@PulumiTagMarker
public class AnalysisSourceEntitySourceTemplateDataSetReferenceArgsBuilder internal constructor() {
    private var dataSetArn: Output<String>? = null

    private var dataSetPlaceholder: Output<String>? = null

    /**
     * @param value Dataset Amazon Resource Name (ARN).
     */
    @JvmName("ydkjcfehfbalcunq")
    public suspend fun dataSetArn(`value`: Output<String>) {
        this.dataSetArn = value
    }

    /**
     * @param value Dataset placeholder.
     */
    @JvmName("mcekvqbtcurnuvjt")
    public suspend fun dataSetPlaceholder(`value`: Output<String>) {
        this.dataSetPlaceholder = value
    }

    /**
     * @param value Dataset Amazon Resource Name (ARN).
     */
    @JvmName("damllxsoldfmvyfl")
    public suspend fun dataSetArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetArn = mapped
    }

    /**
     * @param value Dataset placeholder.
     */
    @JvmName("adyxxvfiusfxbjim")
    public suspend fun dataSetPlaceholder(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSetPlaceholder = mapped
    }

    internal fun build(): AnalysisSourceEntitySourceTemplateDataSetReferenceArgs =
        AnalysisSourceEntitySourceTemplateDataSetReferenceArgs(
            dataSetArn = dataSetArn ?: throw PulumiNullFieldException("dataSetArn"),
            dataSetPlaceholder = dataSetPlaceholder ?: throw PulumiNullFieldException("dataSetPlaceholder"),
        )
}
