@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardParametersArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dateTimeParameters A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
 * @property decimalParameters A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
 * @property integerParameters A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
 * @property stringParameters A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
 */
public data class DashboardParametersArgs(
    public val dateTimeParameters: Output<List<DashboardParametersDateTimeParameterArgs>>? = null,
    public val decimalParameters: Output<List<DashboardParametersDecimalParameterArgs>>? = null,
    public val integerParameters: Output<List<DashboardParametersIntegerParameterArgs>>? = null,
    public val stringParameters: Output<List<DashboardParametersStringParameterArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardParametersArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardParametersArgs =
        com.pulumi.aws.quicksight.inputs.DashboardParametersArgs.builder()
            .dateTimeParameters(
                dateTimeParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .decimalParameters(
                decimalParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .integerParameters(
                integerParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .stringParameters(
                stringParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardParametersArgs].
 */
@PulumiTagMarker
public class DashboardParametersArgsBuilder internal constructor() {
    private var dateTimeParameters: Output<List<DashboardParametersDateTimeParameterArgs>>? = null

    private var decimalParameters: Output<List<DashboardParametersDecimalParameterArgs>>? = null

    private var integerParameters: Output<List<DashboardParametersIntegerParameterArgs>>? = null

    private var stringParameters: Output<List<DashboardParametersStringParameterArgs>>? = null

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("farsqyyfvecbdxql")
    public suspend fun dateTimeParameters(`value`: Output<List<DashboardParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = value
    }

    @JvmName("tftqdqdmhesmvknh")
    public suspend fun dateTimeParameters(vararg values: Output<DashboardParametersDateTimeParameterArgs>) {
        this.dateTimeParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("wlpytinhwrfharyp")
    public suspend fun dateTimeParameters(values: List<Output<DashboardParametersDateTimeParameterArgs>>) {
        this.dateTimeParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("jlwnpolnxwilymwq")
    public suspend fun decimalParameters(`value`: Output<List<DashboardParametersDecimalParameterArgs>>) {
        this.decimalParameters = value
    }

    @JvmName("ynvdkglvgqfbvhdg")
    public suspend fun decimalParameters(vararg values: Output<DashboardParametersDecimalParameterArgs>) {
        this.decimalParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("xabyqelkypylgkhd")
    public suspend fun decimalParameters(values: List<Output<DashboardParametersDecimalParameterArgs>>) {
        this.decimalParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("vbanoeiucpjxcssw")
    public suspend fun integerParameters(`value`: Output<List<DashboardParametersIntegerParameterArgs>>) {
        this.integerParameters = value
    }

    @JvmName("ovcheinojdptitic")
    public suspend fun integerParameters(vararg values: Output<DashboardParametersIntegerParameterArgs>) {
        this.integerParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("dfipodgbkuacfetf")
    public suspend fun integerParameters(values: List<Output<DashboardParametersIntegerParameterArgs>>) {
        this.integerParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("fvjqjjmnhdolbbmh")
    public suspend fun stringParameters(`value`: Output<List<DashboardParametersStringParameterArgs>>) {
        this.stringParameters = value
    }

    @JvmName("hjwsadoewaraosyg")
    public suspend fun stringParameters(vararg values: Output<DashboardParametersStringParameterArgs>) {
        this.stringParameters = Output.all(values.asList())
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("kymxycvqblapxrvg")
    public suspend fun stringParameters(values: List<Output<DashboardParametersStringParameterArgs>>) {
        this.stringParameters = Output.all(values)
    }

    /**
     * @param value A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("pdommoiqpyrbquag")
    public suspend fun dateTimeParameters(`value`: List<DashboardParametersDateTimeParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("cyeskuibnnjqskqq")
    public suspend fun dateTimeParameters(argument: List<suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("jffsrrmbhosqbfhk")
    public suspend fun dateTimeParameters(vararg argument: suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("mnshfxksgttougrx")
    public suspend fun dateTimeParameters(argument: suspend DashboardParametersDateTimeParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersDateTimeParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dateTimeParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of date-time. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DateTimeParameter.html).
     */
    @JvmName("jsiephahpimblcjc")
    public suspend fun dateTimeParameters(vararg values: DashboardParametersDateTimeParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dateTimeParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("hhrolwtgoebsyeid")
    public suspend fun decimalParameters(`value`: List<DashboardParametersDecimalParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("xamluljyupnvebsp")
    public suspend fun decimalParameters(argument: List<suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("ndmrpvokpxhujgwn")
    public suspend fun decimalParameters(vararg argument: suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardParametersDecimalParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("qukbkrrfujjeufxe")
    public suspend fun decimalParameters(argument: suspend DashboardParametersDecimalParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersDecimalParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.decimalParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of decimal. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DecimalParameter.html).
     */
    @JvmName("cggfblpkayaktejw")
    public suspend fun decimalParameters(vararg values: DashboardParametersDecimalParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.decimalParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("vkfffogygnkmdjpy")
    public suspend fun integerParameters(`value`: List<DashboardParametersIntegerParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("wjciatpdaljvbgbw")
    public suspend fun integerParameters(argument: List<suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("jjwlilvjvjspjinb")
    public suspend fun integerParameters(vararg argument: suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardParametersIntegerParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("ghxqmbvskfspgyyv")
    public suspend fun integerParameters(argument: suspend DashboardParametersIntegerParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersIntegerParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.integerParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of integer. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_IntegerParameter.html).
     */
    @JvmName("gjwjxprrgqopoolr")
    public suspend fun integerParameters(vararg values: DashboardParametersIntegerParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.integerParameters = mapped
    }

    /**
     * @param value A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("tvpeegxlxhhvodtr")
    public suspend fun stringParameters(`value`: List<DashboardParametersStringParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("pbbpbbtnkaflwbmw")
    public suspend fun stringParameters(argument: List<suspend DashboardParametersStringParameterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DashboardParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("kuibtyuhqrejtcsc")
    public suspend fun stringParameters(vararg argument: suspend DashboardParametersStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DashboardParametersStringParameterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param argument A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("heudxnwwtfupvbvm")
    public suspend fun stringParameters(argument: suspend DashboardParametersStringParameterArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DashboardParametersStringParameterArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.stringParameters = mapped
    }

    /**
     * @param values A list of parameters that have a data type of string. See [AWS API Documentation for complete description](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_StringParameter.html).
     */
    @JvmName("fmyxxkjyxcsfqvhs")
    public suspend fun stringParameters(vararg values: DashboardParametersStringParameterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stringParameters = mapped
    }

    internal fun build(): DashboardParametersArgs = DashboardParametersArgs(
        dateTimeParameters = dateTimeParameters,
        decimalParameters = decimalParameters,
        integerParameters = integerParameters,
        stringParameters = stringParameters,
    )
}
