@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property sourceTemplate The source template. See source_template.
 */
public data class DashboardSourceEntityArgs(
    public val sourceTemplate: Output<DashboardSourceEntitySourceTemplateArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs =
        com.pulumi.aws.quicksight.inputs.DashboardSourceEntityArgs.builder()
            .sourceTemplate(
                sourceTemplate?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DashboardSourceEntityArgs].
 */
@PulumiTagMarker
public class DashboardSourceEntityArgsBuilder internal constructor() {
    private var sourceTemplate: Output<DashboardSourceEntitySourceTemplateArgs>? = null

    /**
     * @param value The source template. See source_template.
     */
    @JvmName("vloyisneflfkqkew")
    public suspend fun sourceTemplate(`value`: Output<DashboardSourceEntitySourceTemplateArgs>) {
        this.sourceTemplate = value
    }

    /**
     * @param value The source template. See source_template.
     */
    @JvmName("qjuivmmpfwcjnjtm")
    public suspend fun sourceTemplate(`value`: DashboardSourceEntitySourceTemplateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceTemplate = mapped
    }

    /**
     * @param argument The source template. See source_template.
     */
    @JvmName("wplnjajfdrmdmann")
    public suspend fun sourceTemplate(argument: suspend DashboardSourceEntitySourceTemplateArgsBuilder.() -> Unit) {
        val toBeMapped = DashboardSourceEntitySourceTemplateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sourceTemplate = mapped
    }

    internal fun build(): DashboardSourceEntityArgs = DashboardSourceEntityArgs(
        sourceTemplate = sourceTemplate,
    )
}
