@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetColumnGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property geoSpatialColumnGroup Geospatial column group that denotes a hierarchy. See geo_spatial_column_group.
 */
public data class DataSetColumnGroupArgs(
    public val geoSpatialColumnGroup: Output<DataSetColumnGroupGeoSpatialColumnGroupArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetColumnGroupArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetColumnGroupArgs =
        com.pulumi.aws.quicksight.inputs.DataSetColumnGroupArgs.builder()
            .geoSpatialColumnGroup(
                geoSpatialColumnGroup?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetColumnGroupArgs].
 */
@PulumiTagMarker
public class DataSetColumnGroupArgsBuilder internal constructor() {
    private var geoSpatialColumnGroup: Output<DataSetColumnGroupGeoSpatialColumnGroupArgs>? = null

    /**
     * @param value Geospatial column group that denotes a hierarchy. See geo_spatial_column_group.
     */
    @JvmName("gfklmyjofyptklbu")
    public suspend fun geoSpatialColumnGroup(`value`: Output<DataSetColumnGroupGeoSpatialColumnGroupArgs>) {
        this.geoSpatialColumnGroup = value
    }

    /**
     * @param value Geospatial column group that denotes a hierarchy. See geo_spatial_column_group.
     */
    @JvmName("nwjevfrjgwblewjj")
    public suspend fun geoSpatialColumnGroup(`value`: DataSetColumnGroupGeoSpatialColumnGroupArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoSpatialColumnGroup = mapped
    }

    /**
     * @param argument Geospatial column group that denotes a hierarchy. See geo_spatial_column_group.
     */
    @JvmName("satspcyfvhrrlflx")
    public suspend fun geoSpatialColumnGroup(argument: suspend DataSetColumnGroupGeoSpatialColumnGroupArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetColumnGroupGeoSpatialColumnGroupArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.geoSpatialColumnGroup = mapped
    }

    internal fun build(): DataSetColumnGroupArgs = DataSetColumnGroupArgs(
        geoSpatialColumnGroup = geoSpatialColumnGroup,
    )
}
