@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetDataSetUsageConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property disableUseAsDirectQuerySource Controls whether a child dataset of a direct query can use this dataset as a source.
 * @property disableUseAsImportedSource Controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
 */
public data class DataSetDataSetUsageConfigurationArgs(
    public val disableUseAsDirectQuerySource: Output<Boolean>? = null,
    public val disableUseAsImportedSource: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetDataSetUsageConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetDataSetUsageConfigurationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetDataSetUsageConfigurationArgs.builder()
            .disableUseAsDirectQuerySource(disableUseAsDirectQuerySource?.applyValue({ args0 -> args0 }))
            .disableUseAsImportedSource(disableUseAsImportedSource?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetDataSetUsageConfigurationArgs].
 */
@PulumiTagMarker
public class DataSetDataSetUsageConfigurationArgsBuilder internal constructor() {
    private var disableUseAsDirectQuerySource: Output<Boolean>? = null

    private var disableUseAsImportedSource: Output<Boolean>? = null

    /**
     * @param value Controls whether a child dataset of a direct query can use this dataset as a source.
     */
    @JvmName("tpcixhsspeusapxo")
    public suspend fun disableUseAsDirectQuerySource(`value`: Output<Boolean>) {
        this.disableUseAsDirectQuerySource = value
    }

    /**
     * @param value Controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
     */
    @JvmName("wxdclsfofooearvg")
    public suspend fun disableUseAsImportedSource(`value`: Output<Boolean>) {
        this.disableUseAsImportedSource = value
    }

    /**
     * @param value Controls whether a child dataset of a direct query can use this dataset as a source.
     */
    @JvmName("bifwlvatagagkfdo")
    public suspend fun disableUseAsDirectQuerySource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableUseAsDirectQuerySource = mapped
    }

    /**
     * @param value Controls whether a child dataset that's stored in QuickSight can use this dataset as a source.
     */
    @JvmName("dlfuabebugapqibq")
    public suspend fun disableUseAsImportedSource(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableUseAsImportedSource = mapped
    }

    internal fun build(): DataSetDataSetUsageConfigurationArgs = DataSetDataSetUsageConfigurationArgs(
        disableUseAsDirectQuerySource = disableUseAsDirectQuerySource,
        disableUseAsImportedSource = disableUseAsImportedSource,
    )
}
