@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property alias A display name for the logical table.
 * @property dataTransforms Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
 * @property logicalTableMapId Key of the logical table map.
 * @property source Source of this logical table. See source.
 */
public data class DataSetLogicalTableMapArgs(
    public val alias: Output<String>,
    public val dataTransforms: Output<List<DataSetLogicalTableMapDataTransformArgs>>? = null,
    public val logicalTableMapId: Output<String>,
    public val source: Output<DataSetLogicalTableMapSourceArgs>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapArgs.builder()
            .alias(alias.applyValue({ args0 -> args0 }))
            .dataTransforms(
                dataTransforms?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .logicalTableMapId(logicalTableMapId.applyValue({ args0 -> args0 }))
            .source(source.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DataSetLogicalTableMapArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var dataTransforms: Output<List<DataSetLogicalTableMapDataTransformArgs>>? = null

    private var logicalTableMapId: Output<String>? = null

    private var source: Output<DataSetLogicalTableMapSourceArgs>? = null

    /**
     * @param value A display name for the logical table.
     */
    @JvmName("uxlxksdqemhugycp")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("gxgnqbeqdeuwsmlj")
    public suspend fun dataTransforms(`value`: Output<List<DataSetLogicalTableMapDataTransformArgs>>) {
        this.dataTransforms = value
    }

    @JvmName("tcdpmyacmttursdj")
    public suspend fun dataTransforms(vararg values: Output<DataSetLogicalTableMapDataTransformArgs>) {
        this.dataTransforms = Output.all(values.asList())
    }

    /**
     * @param values Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("gcwtnmcshagblgwk")
    public suspend fun dataTransforms(values: List<Output<DataSetLogicalTableMapDataTransformArgs>>) {
        this.dataTransforms = Output.all(values)
    }

    /**
     * @param value Key of the logical table map.
     */
    @JvmName("nlknsrcojixjnfgv")
    public suspend fun logicalTableMapId(`value`: Output<String>) {
        this.logicalTableMapId = value
    }

    /**
     * @param value Source of this logical table. See source.
     */
    @JvmName("logdxpclcmsxtxnq")
    public suspend fun source(`value`: Output<DataSetLogicalTableMapSourceArgs>) {
        this.source = value
    }

    /**
     * @param value A display name for the logical table.
     */
    @JvmName("audimhogcuuqcrgs")
    public suspend fun alias(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("nstvcionhxixdvwh")
    public suspend fun dataTransforms(`value`: List<DataSetLogicalTableMapDataTransformArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataTransforms = mapped
    }

    /**
     * @param argument Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("dunfytgspgkrlhlj")
    public suspend fun dataTransforms(argument: List<suspend DataSetLogicalTableMapDataTransformArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataTransforms = mapped
    }

    /**
     * @param argument Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("ifofsfppnbwqexub")
    public suspend fun dataTransforms(vararg argument: suspend DataSetLogicalTableMapDataTransformArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.dataTransforms = mapped
    }

    /**
     * @param argument Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("tjynhmvradvhkknr")
    public suspend fun dataTransforms(argument: suspend DataSetLogicalTableMapDataTransformArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataSetLogicalTableMapDataTransformArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dataTransforms = mapped
    }

    /**
     * @param values Transform operations that act on this logical table. For this structure to be valid, only one of the attributes can be non-null. See data_transforms.
     */
    @JvmName("hscliejspfnibchf")
    public suspend fun dataTransforms(vararg values: DataSetLogicalTableMapDataTransformArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataTransforms = mapped
    }

    /**
     * @param value Key of the logical table map.
     */
    @JvmName("pvwwnvbkfkxxyutm")
    public suspend fun logicalTableMapId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logicalTableMapId = mapped
    }

    /**
     * @param value Source of this logical table. See source.
     */
    @JvmName("ebkrkwyubuanljen")
    public suspend fun source(`value`: DataSetLogicalTableMapSourceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param argument Source of this logical table. See source.
     */
    @JvmName("yjwtcdjfomsndifd")
    public suspend fun source(argument: suspend DataSetLogicalTableMapSourceArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetLogicalTableMapSourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.source = mapped
    }

    internal fun build(): DataSetLogicalTableMapArgs = DataSetLogicalTableMapArgs(
        alias = alias ?: throw PulumiNullFieldException("alias"),
        dataTransforms = dataTransforms,
        logicalTableMapId = logicalTableMapId ?: throw PulumiNullFieldException("logicalTableMapId"),
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
