@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property castColumnTypeOperation A transform operation that casts a column to a different type. See cast_column_type_operation.
 * @property createColumnsOperation An operation that creates calculated columns. Columns created in one such operation form a lexical closure. See create_columns_operation.
 * @property filterOperation An operation that filters rows based on some condition. See filter_operation.
 * @property projectOperation An operation that projects columns. Operations that come after a projection can only refer to projected columns. See project_operation.
 * @property renameColumnOperation An operation that renames a column. See rename_column_operation.
 * @property tagColumnOperation An operation that tags a column with additional information. See tag_column_operation.
 * @property untagColumnOperation A transform operation that removes tags associated with a column. See untag_column_operation.
 */
public data class DataSetLogicalTableMapDataTransformArgs(
    public val castColumnTypeOperation: Output<DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs>? = null,
    public val createColumnsOperation: Output<DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs>? = null,
    public val filterOperation: Output<DataSetLogicalTableMapDataTransformFilterOperationArgs>? =
        null,
    public val projectOperation: Output<DataSetLogicalTableMapDataTransformProjectOperationArgs>? =
        null,
    public val renameColumnOperation: Output<DataSetLogicalTableMapDataTransformRenameColumnOperationArgs>? = null,
    public val tagColumnOperation: Output<DataSetLogicalTableMapDataTransformTagColumnOperationArgs>? =
        null,
    public val untagColumnOperation: Output<DataSetLogicalTableMapDataTransformUntagColumnOperationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformArgs.builder()
            .castColumnTypeOperation(
                castColumnTypeOperation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .createColumnsOperation(
                createColumnsOperation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .filterOperation(filterOperation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .projectOperation(projectOperation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .renameColumnOperation(
                renameColumnOperation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tagColumnOperation(
                tagColumnOperation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .untagColumnOperation(
                untagColumnOperation?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformArgsBuilder internal constructor() {
    private var castColumnTypeOperation:
        Output<DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs>? = null

    private var createColumnsOperation:
        Output<DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs>? = null

    private var filterOperation: Output<DataSetLogicalTableMapDataTransformFilterOperationArgs>? =
        null

    private var projectOperation: Output<DataSetLogicalTableMapDataTransformProjectOperationArgs>? =
        null

    private var renameColumnOperation:
        Output<DataSetLogicalTableMapDataTransformRenameColumnOperationArgs>? = null

    private var tagColumnOperation: Output<DataSetLogicalTableMapDataTransformTagColumnOperationArgs>? =
        null

    private var untagColumnOperation:
        Output<DataSetLogicalTableMapDataTransformUntagColumnOperationArgs>? = null

    /**
     * @param value A transform operation that casts a column to a different type. See cast_column_type_operation.
     */
    @JvmName("omqjhvpnymjqfyye")
    public suspend fun castColumnTypeOperation(`value`: Output<DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs>) {
        this.castColumnTypeOperation = value
    }

    /**
     * @param value An operation that creates calculated columns. Columns created in one such operation form a lexical closure. See create_columns_operation.
     */
    @JvmName("gjgmnetlbwisiesi")
    public suspend fun createColumnsOperation(`value`: Output<DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs>) {
        this.createColumnsOperation = value
    }

    /**
     * @param value An operation that filters rows based on some condition. See filter_operation.
     */
    @JvmName("jrkbcutdsyatknba")
    public suspend fun filterOperation(`value`: Output<DataSetLogicalTableMapDataTransformFilterOperationArgs>) {
        this.filterOperation = value
    }

    /**
     * @param value An operation that projects columns. Operations that come after a projection can only refer to projected columns. See project_operation.
     */
    @JvmName("xgsymseyadriaucw")
    public suspend fun projectOperation(`value`: Output<DataSetLogicalTableMapDataTransformProjectOperationArgs>) {
        this.projectOperation = value
    }

    /**
     * @param value An operation that renames a column. See rename_column_operation.
     */
    @JvmName("oxqksistqqxpgwcm")
    public suspend fun renameColumnOperation(`value`: Output<DataSetLogicalTableMapDataTransformRenameColumnOperationArgs>) {
        this.renameColumnOperation = value
    }

    /**
     * @param value An operation that tags a column with additional information. See tag_column_operation.
     */
    @JvmName("pgyiqbylaechukvw")
    public suspend fun tagColumnOperation(`value`: Output<DataSetLogicalTableMapDataTransformTagColumnOperationArgs>) {
        this.tagColumnOperation = value
    }

    /**
     * @param value A transform operation that removes tags associated with a column. See untag_column_operation.
     */
    @JvmName("esstgyywlyocscwi")
    public suspend fun untagColumnOperation(`value`: Output<DataSetLogicalTableMapDataTransformUntagColumnOperationArgs>) {
        this.untagColumnOperation = value
    }

    /**
     * @param value A transform operation that casts a column to a different type. See cast_column_type_operation.
     */
    @JvmName("fjlqmjbmdfckdxvk")
    public suspend fun castColumnTypeOperation(`value`: DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.castColumnTypeOperation = mapped
    }

    /**
     * @param argument A transform operation that casts a column to a different type. See cast_column_type_operation.
     */
    @JvmName("ehotbvodvbtvghor")
    public suspend fun castColumnTypeOperation(argument: suspend DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformCastColumnTypeOperationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.castColumnTypeOperation = mapped
    }

    /**
     * @param value An operation that creates calculated columns. Columns created in one such operation form a lexical closure. See create_columns_operation.
     */
    @JvmName("kaiwouwdovtsmqvd")
    public suspend fun createColumnsOperation(`value`: DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createColumnsOperation = mapped
    }

    /**
     * @param argument An operation that creates calculated columns. Columns created in one such operation form a lexical closure. See create_columns_operation.
     */
    @JvmName("xcprgxvjvxwcqmqm")
    public suspend fun createColumnsOperation(argument: suspend DataSetLogicalTableMapDataTransformCreateColumnsOperationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformCreateColumnsOperationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.createColumnsOperation = mapped
    }

    /**
     * @param value An operation that filters rows based on some condition. See filter_operation.
     */
    @JvmName("okojrudcvdupkfvm")
    public suspend fun filterOperation(`value`: DataSetLogicalTableMapDataTransformFilterOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filterOperation = mapped
    }

    /**
     * @param argument An operation that filters rows based on some condition. See filter_operation.
     */
    @JvmName("njadxahuuhpvcdal")
    public suspend fun filterOperation(argument: suspend DataSetLogicalTableMapDataTransformFilterOperationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetLogicalTableMapDataTransformFilterOperationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filterOperation = mapped
    }

    /**
     * @param value An operation that projects columns. Operations that come after a projection can only refer to projected columns. See project_operation.
     */
    @JvmName("khdifojlcywolxjo")
    public suspend fun projectOperation(`value`: DataSetLogicalTableMapDataTransformProjectOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectOperation = mapped
    }

    /**
     * @param argument An operation that projects columns. Operations that come after a projection can only refer to projected columns. See project_operation.
     */
    @JvmName("vikyiotbcrfnmyug")
    public suspend fun projectOperation(argument: suspend DataSetLogicalTableMapDataTransformProjectOperationArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetLogicalTableMapDataTransformProjectOperationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.projectOperation = mapped
    }

    /**
     * @param value An operation that renames a column. See rename_column_operation.
     */
    @JvmName("wdomgenuuvpsxrbr")
    public suspend fun renameColumnOperation(`value`: DataSetLogicalTableMapDataTransformRenameColumnOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renameColumnOperation = mapped
    }

    /**
     * @param argument An operation that renames a column. See rename_column_operation.
     */
    @JvmName("qjphhaerttsiepbe")
    public suspend fun renameColumnOperation(argument: suspend DataSetLogicalTableMapDataTransformRenameColumnOperationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformRenameColumnOperationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.renameColumnOperation = mapped
    }

    /**
     * @param value An operation that tags a column with additional information. See tag_column_operation.
     */
    @JvmName("bfxmgkirjtmljito")
    public suspend fun tagColumnOperation(`value`: DataSetLogicalTableMapDataTransformTagColumnOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagColumnOperation = mapped
    }

    /**
     * @param argument An operation that tags a column with additional information. See tag_column_operation.
     */
    @JvmName("xuxxyncclcaupudc")
    public suspend fun tagColumnOperation(argument: suspend DataSetLogicalTableMapDataTransformTagColumnOperationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformTagColumnOperationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tagColumnOperation = mapped
    }

    /**
     * @param value A transform operation that removes tags associated with a column. See untag_column_operation.
     */
    @JvmName("fsofhvsqoeictuyu")
    public suspend fun untagColumnOperation(`value`: DataSetLogicalTableMapDataTransformUntagColumnOperationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.untagColumnOperation = mapped
    }

    /**
     * @param argument A transform operation that removes tags associated with a column. See untag_column_operation.
     */
    @JvmName("tdexkkjwwxgaxvsd")
    public suspend fun untagColumnOperation(argument: suspend DataSetLogicalTableMapDataTransformUntagColumnOperationArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformUntagColumnOperationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.untagColumnOperation = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformArgs =
        DataSetLogicalTableMapDataTransformArgs(
            castColumnTypeOperation = castColumnTypeOperation,
            createColumnsOperation = createColumnsOperation,
            filterOperation = filterOperation,
            projectOperation = projectOperation,
            renameColumnOperation = renameColumnOperation,
            tagColumnOperation = tagColumnOperation,
            untagColumnOperation = untagColumnOperation,
        )
}
