@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columns Calculated columns to create. See columns.
 */
public data class DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs(
    public val columns: Output<List<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs.builder()
            .columns(
                columns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformCreateColumnsOperationArgsBuilder internal constructor() {
    private var columns:
        Output<List<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>>? = null

    /**
     * @param value Calculated columns to create. See columns.
     */
    @JvmName("vheysqccvmiipeen")
    public suspend fun columns(`value`: Output<List<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>>) {
        this.columns = value
    }

    @JvmName("kjbcqgthgbddumpb")
    public suspend fun columns(vararg values: Output<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Calculated columns to create. See columns.
     */
    @JvmName("aitpyxegarmpraoq")
    public suspend fun columns(values: List<Output<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value Calculated columns to create. See columns.
     */
    @JvmName("ixqssrjnikbdejku")
    public suspend fun columns(`value`: List<DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument Calculated columns to create. See columns.
     */
    @JvmName("qjclpectwflhyvik")
    public suspend fun columns(argument: List<suspend DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Calculated columns to create. See columns.
     */
    @JvmName("gpnesbgovxqqppdo")
    public suspend fun columns(vararg argument: suspend DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Calculated columns to create. See columns.
     */
    @JvmName("imoyiqdebnboqvqb")
    public suspend fun columns(argument: suspend DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgsBuilder().applySuspend
                    { argument() }.build(),
            )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values Calculated columns to create. See columns.
     */
    @JvmName("ujxhbqxmuyjunqwl")
    public suspend fun columns(vararg values: DataSetLogicalTableMapDataTransformCreateColumnsOperationColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs =
        DataSetLogicalTableMapDataTransformCreateColumnsOperationArgs(
            columns = columns ?: throw PulumiNullFieldException("columns"),
        )
}
