@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformFilterOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property conditionExpression An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.
 */
public data class DataSetLogicalTableMapDataTransformFilterOperationArgs(
    public val conditionExpression: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformFilterOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformFilterOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformFilterOperationArgs.builder()
            .conditionExpression(conditionExpression.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformFilterOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformFilterOperationArgsBuilder internal constructor() {
    private var conditionExpression: Output<String>? = null

    /**
     * @param value An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.
     */
    @JvmName("fxtbawtgjqxuwfny")
    public suspend fun conditionExpression(`value`: Output<String>) {
        this.conditionExpression = value
    }

    /**
     * @param value An expression that must evaluate to a Boolean value. Rows for which the expression evaluates to true are kept in the dataset.
     */
    @JvmName("pieukpwxeahorujv")
    public suspend fun conditionExpression(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.conditionExpression = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformFilterOperationArgs =
        DataSetLogicalTableMapDataTransformFilterOperationArgs(
            conditionExpression = conditionExpression ?: throw PulumiNullFieldException("conditionExpression"),
        )
}
