@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformProjectOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property projectedColumns Projected columns.
 */
public data class DataSetLogicalTableMapDataTransformProjectOperationArgs(
    public val projectedColumns: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformProjectOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformProjectOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformProjectOperationArgs.builder()
            .projectedColumns(projectedColumns.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformProjectOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformProjectOperationArgsBuilder internal constructor() {
    private var projectedColumns: Output<List<String>>? = null

    /**
     * @param value Projected columns.
     */
    @JvmName("hyguqtybxealvidx")
    public suspend fun projectedColumns(`value`: Output<List<String>>) {
        this.projectedColumns = value
    }

    @JvmName("udqfxmgydlyuybpx")
    public suspend fun projectedColumns(vararg values: Output<String>) {
        this.projectedColumns = Output.all(values.asList())
    }

    /**
     * @param values Projected columns.
     */
    @JvmName("nlmkcitiegmbspyh")
    public suspend fun projectedColumns(values: List<Output<String>>) {
        this.projectedColumns = Output.all(values)
    }

    /**
     * @param value Projected columns.
     */
    @JvmName("gjknqtlgilgjfghd")
    public suspend fun projectedColumns(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectedColumns = mapped
    }

    /**
     * @param values Projected columns.
     */
    @JvmName("xhnloegcsybwunck")
    public suspend fun projectedColumns(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectedColumns = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformProjectOperationArgs =
        DataSetLogicalTableMapDataTransformProjectOperationArgs(
            projectedColumns = projectedColumns ?: throw PulumiNullFieldException("projectedColumns"),
        )
}
