@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformRenameColumnOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property columnName Column to be renamed.
 * @property newColumnName New name for the column.
 */
public data class DataSetLogicalTableMapDataTransformRenameColumnOperationArgs(
    public val columnName: Output<String>,
    public val newColumnName: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformRenameColumnOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformRenameColumnOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformRenameColumnOperationArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .newColumnName(newColumnName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformRenameColumnOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformRenameColumnOperationArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var newColumnName: Output<String>? = null

    /**
     * @param value Column to be renamed.
     */
    @JvmName("gwsqkbiadhwxoplb")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value New name for the column.
     */
    @JvmName("hdckuqsuskdcypsk")
    public suspend fun newColumnName(`value`: Output<String>) {
        this.newColumnName = value
    }

    /**
     * @param value Column to be renamed.
     */
    @JvmName("ehgbsirbvfaehtva")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value New name for the column.
     */
    @JvmName("cltldqwchfndfkru")
    public suspend fun newColumnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.newColumnName = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformRenameColumnOperationArgs =
        DataSetLogicalTableMapDataTransformRenameColumnOperationArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            newColumnName = newColumnName ?: throw PulumiNullFieldException("newColumnName"),
        )
}
