@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columnName Column name.
 * @property tags The dataset column tag, currently only used for geospatial type tagging. See tags.
 */
public data class DataSetLogicalTableMapDataTransformTagColumnOperationArgs(
    public val columnName: Output<String>,
    public val tags: Output<List<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .tags(
                tags.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformTagColumnOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformTagColumnOperationArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var tags: Output<List<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>>? =
        null

    /**
     * @param value Column name.
     */
    @JvmName("djfyhkryarbkgwos")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("cmckvgntjvnqcnwq")
    public suspend fun tags(`value`: Output<List<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>>) {
        this.tags = value
    }

    @JvmName("cslwkwujouglmfmg")
    public suspend fun tags(vararg values: Output<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>) {
        this.tags = Output.all(values.asList())
    }

    /**
     * @param values The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("pkvyfardaitijblt")
    public suspend fun tags(values: List<Output<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>>) {
        this.tags = Output.all(values)
    }

    /**
     * @param value Column name.
     */
    @JvmName("uadudtdmmwbwsfmd")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("emkxhewycjfalfin")
    public suspend fun tags(`value`: List<DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param argument The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("bugqcjwvkmofqvor")
    public suspend fun tags(argument: List<suspend DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("pfprojteksalypxq")
    public suspend fun tags(vararg argument: suspend DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param argument The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("oxmbnjfjxyaukxmu")
    public suspend fun tags(argument: suspend DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.tags = mapped
    }

    /**
     * @param values The dataset column tag, currently only used for geospatial type tagging. See tags.
     */
    @JvmName("bgnyhrnidckvjoxf")
    public suspend fun tags(vararg values: DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformTagColumnOperationArgs =
        DataSetLogicalTableMapDataTransformTagColumnOperationArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            tags = tags ?: throw PulumiNullFieldException("tags"),
        )
}
