@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property columnDescription A description for a column. See column_description.
 * @property columnGeographicRole A geospatial role for a column. Valid values are `COUNTRY`, `STATE`, `COUNTY`, `CITY`, `POSTCODE`, `LONGITUDE`, and `LATITUDE`.
 */
public data class DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs(
    public val columnDescription: Output<DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgs>? = null,
    public val columnGeographicRole: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs.builder()
            .columnDescription(columnDescription?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .columnGeographicRole(columnGeographicRole?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformTagColumnOperationTagArgsBuilder internal constructor() {
    private var columnDescription:
        Output<DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgs>? = null

    private var columnGeographicRole: Output<String>? = null

    /**
     * @param value A description for a column. See column_description.
     */
    @JvmName("ybhhqsbxfegmfnci")
    public suspend fun columnDescription(`value`: Output<DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgs>) {
        this.columnDescription = value
    }

    /**
     * @param value A geospatial role for a column. Valid values are `COUNTRY`, `STATE`, `COUNTY`, `CITY`, `POSTCODE`, `LONGITUDE`, and `LATITUDE`.
     */
    @JvmName("lndupqrwrlgnawbg")
    public suspend fun columnGeographicRole(`value`: Output<String>) {
        this.columnGeographicRole = value
    }

    /**
     * @param value A description for a column. See column_description.
     */
    @JvmName("iykgdgweicovwajq")
    public suspend fun columnDescription(`value`: DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnDescription = mapped
    }

    /**
     * @param argument A description for a column. See column_description.
     */
    @JvmName("dhtpyfouaaypnaoo")
    public suspend fun columnDescription(argument: suspend DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped =
            DataSetLogicalTableMapDataTransformTagColumnOperationTagColumnDescriptionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.columnDescription = mapped
    }

    /**
     * @param value A geospatial role for a column. Valid values are `COUNTRY`, `STATE`, `COUNTY`, `CITY`, `POSTCODE`, `LONGITUDE`, and `LATITUDE`.
     */
    @JvmName("surbdofblavfsyfq")
    public suspend fun columnGeographicRole(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnGeographicRole = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs =
        DataSetLogicalTableMapDataTransformTagColumnOperationTagArgs(
            columnDescription = columnDescription,
            columnGeographicRole = columnGeographicRole,
        )
}
