@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformUntagColumnOperationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columnName Column name.
 * @property tagNames The column tags to remove from this column.
 */
public data class DataSetLogicalTableMapDataTransformUntagColumnOperationArgs(
    public val columnName: Output<String>,
    public val tagNames: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformUntagColumnOperationArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformUntagColumnOperationArgs =
        com.pulumi.aws.quicksight.inputs.DataSetLogicalTableMapDataTransformUntagColumnOperationArgs.builder()
            .columnName(columnName.applyValue({ args0 -> args0 }))
            .tagNames(tagNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [DataSetLogicalTableMapDataTransformUntagColumnOperationArgs].
 */
@PulumiTagMarker
public class DataSetLogicalTableMapDataTransformUntagColumnOperationArgsBuilder internal constructor() {
    private var columnName: Output<String>? = null

    private var tagNames: Output<List<String>>? = null

    /**
     * @param value Column name.
     */
    @JvmName("aedkcbuftsqtisrq")
    public suspend fun columnName(`value`: Output<String>) {
        this.columnName = value
    }

    /**
     * @param value The column tags to remove from this column.
     */
    @JvmName("petkbmcjdlmskgjn")
    public suspend fun tagNames(`value`: Output<List<String>>) {
        this.tagNames = value
    }

    @JvmName("fwidpuodjvmxyqgq")
    public suspend fun tagNames(vararg values: Output<String>) {
        this.tagNames = Output.all(values.asList())
    }

    /**
     * @param values The column tags to remove from this column.
     */
    @JvmName("woyqnruvehmryjmh")
    public suspend fun tagNames(values: List<Output<String>>) {
        this.tagNames = Output.all(values)
    }

    /**
     * @param value Column name.
     */
    @JvmName("pudrwuhdboulwxbb")
    public suspend fun columnName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The column tags to remove from this column.
     */
    @JvmName("qpsxqklxbgjxinvg")
    public suspend fun tagNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagNames = mapped
    }

    /**
     * @param values The column tags to remove from this column.
     */
    @JvmName("adatujviwcoshktk")
    public suspend fun tagNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tagNames = mapped
    }

    internal fun build(): DataSetLogicalTableMapDataTransformUntagColumnOperationArgs =
        DataSetLogicalTableMapDataTransformUntagColumnOperationArgs(
            columnName = columnName ?: throw PulumiNullFieldException("columnName"),
            tagNames = tagNames ?: throw PulumiNullFieldException("tagNames"),
        )
}
