@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property actions List of IAM actions to grant or revoke permissions on.
 * @property principal ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
 */
public data class DataSetPermissionArgs(
    public val actions: Output<List<String>>,
    public val principal: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPermissionArgs.builder()
            .actions(actions.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principal(principal.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPermissionArgs].
 */
@PulumiTagMarker
public class DataSetPermissionArgsBuilder internal constructor() {
    private var actions: Output<List<String>>? = null

    private var principal: Output<String>? = null

    /**
     * @param value List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("vqmasnlbdyocllks")
    public suspend fun actions(`value`: Output<List<String>>) {
        this.actions = value
    }

    @JvmName("orysswfopnbrcgth")
    public suspend fun actions(vararg values: Output<String>) {
        this.actions = Output.all(values.asList())
    }

    /**
     * @param values List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("khwweeafdocnachl")
    public suspend fun actions(values: List<Output<String>>) {
        this.actions = Output.all(values)
    }

    /**
     * @param value ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
     */
    @JvmName("hwqqtbstuwqfswrg")
    public suspend fun principal(`value`: Output<String>) {
        this.principal = value
    }

    /**
     * @param value List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("xorwhrlsgapvipio")
    public suspend fun actions(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param values List of IAM actions to grant or revoke permissions on.
     */
    @JvmName("aytuppyspuigdaxd")
    public suspend fun actions(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.actions = mapped
    }

    /**
     * @param value ARN of the principal. See the [ResourcePermission documentation](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_ResourcePermission.html) for the applicable ARN values.
     */
    @JvmName("mnmeodfflgldlpeu")
    public suspend fun principal(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principal = mapped
    }

    internal fun build(): DataSetPermissionArgs = DataSetPermissionArgs(
        actions = actions ?: throw PulumiNullFieldException("actions"),
        principal = principal ?: throw PulumiNullFieldException("principal"),
    )
}
