@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapCustomSqlArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property columns Column schema from the SQL query result set. See columns.
 * @property dataSourceArn ARN of the data source.
 * @property name Display name for the SQL query result.
 * @property sqlQuery SQL query.
 */
public data class DataSetPhysicalTableMapCustomSqlArgs(
    public val columns: Output<List<DataSetPhysicalTableMapCustomSqlColumnArgs>>? = null,
    public val dataSourceArn: Output<String>,
    public val name: Output<String>,
    public val sqlQuery: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapCustomSqlArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapCustomSqlArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapCustomSqlArgs.builder()
            .columns(
                columns?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .dataSourceArn(dataSourceArn.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .sqlQuery(sqlQuery.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapCustomSqlArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapCustomSqlArgsBuilder internal constructor() {
    private var columns: Output<List<DataSetPhysicalTableMapCustomSqlColumnArgs>>? = null

    private var dataSourceArn: Output<String>? = null

    private var name: Output<String>? = null

    private var sqlQuery: Output<String>? = null

    /**
     * @param value Column schema from the SQL query result set. See columns.
     */
    @JvmName("dchucrkqxlvsxfve")
    public suspend fun columns(`value`: Output<List<DataSetPhysicalTableMapCustomSqlColumnArgs>>) {
        this.columns = value
    }

    @JvmName("qwlfjcxgxobmfaaj")
    public suspend fun columns(vararg values: Output<DataSetPhysicalTableMapCustomSqlColumnArgs>) {
        this.columns = Output.all(values.asList())
    }

    /**
     * @param values Column schema from the SQL query result set. See columns.
     */
    @JvmName("hbeogqhuqcepplnc")
    public suspend fun columns(values: List<Output<DataSetPhysicalTableMapCustomSqlColumnArgs>>) {
        this.columns = Output.all(values)
    }

    /**
     * @param value ARN of the data source.
     */
    @JvmName("lnebncicwydoydte")
    public suspend fun dataSourceArn(`value`: Output<String>) {
        this.dataSourceArn = value
    }

    /**
     * @param value Display name for the SQL query result.
     */
    @JvmName("ccwwtnbsqxoeuvrc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value SQL query.
     */
    @JvmName("sfrbgaxpanfdrpqf")
    public suspend fun sqlQuery(`value`: Output<String>) {
        this.sqlQuery = value
    }

    /**
     * @param value Column schema from the SQL query result set. See columns.
     */
    @JvmName("cpgfvcsxonxlcfle")
    public suspend fun columns(`value`: List<DataSetPhysicalTableMapCustomSqlColumnArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param argument Column schema from the SQL query result set. See columns.
     */
    @JvmName("bgyvtlgvblhcuqme")
    public suspend fun columns(argument: List<suspend DataSetPhysicalTableMapCustomSqlColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapCustomSqlColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Column schema from the SQL query result set. See columns.
     */
    @JvmName("tsgdsihfwtcbxpkq")
    public suspend fun columns(vararg argument: suspend DataSetPhysicalTableMapCustomSqlColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapCustomSqlColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param argument Column schema from the SQL query result set. See columns.
     */
    @JvmName("qavdlibadxotrnbc")
    public suspend fun columns(argument: suspend DataSetPhysicalTableMapCustomSqlColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataSetPhysicalTableMapCustomSqlColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.columns = mapped
    }

    /**
     * @param values Column schema from the SQL query result set. See columns.
     */
    @JvmName("ncspqcnnbhrkgish")
    public suspend fun columns(vararg values: DataSetPhysicalTableMapCustomSqlColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.columns = mapped
    }

    /**
     * @param value ARN of the data source.
     */
    @JvmName("cksaokqiibwteiuj")
    public suspend fun dataSourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceArn = mapped
    }

    /**
     * @param value Display name for the SQL query result.
     */
    @JvmName("mptbmqtpekahdoef")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value SQL query.
     */
    @JvmName("jkwbmgengbjsemfj")
    public suspend fun sqlQuery(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sqlQuery = mapped
    }

    internal fun build(): DataSetPhysicalTableMapCustomSqlArgs = DataSetPhysicalTableMapCustomSqlArgs(
        columns = columns,
        dataSourceArn = dataSourceArn ?: throw PulumiNullFieldException("dataSourceArn"),
        name = name ?: throw PulumiNullFieldException("name"),
        sqlQuery = sqlQuery ?: throw PulumiNullFieldException("sqlQuery"),
    )
}
