@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableInputColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of this column in the underlying data source.
 * @property type Data type of the column.
 */
public data class DataSetPhysicalTableMapRelationalTableInputColumnArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableInputColumnArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableInputColumnArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapRelationalTableInputColumnArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapRelationalTableInputColumnArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapRelationalTableInputColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of this column in the underlying data source.
     */
    @JvmName("apaswvtnxuvbyvxf")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("kiwgmgeudmcqgayw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of this column in the underlying data source.
     */
    @JvmName("leqfroiqukhievfq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("cappcffshkgoarai")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataSetPhysicalTableMapRelationalTableInputColumnArgs =
        DataSetPhysicalTableMapRelationalTableInputColumnArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
