@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dataSourceArn ARN of the data source.
 * @property inputColumns Column schema of the table. See input_columns.
 * @property uploadSettings Information about the format for the S3 source file or files. See upload_settings.
 */
public data class DataSetPhysicalTableMapS3SourceArgs(
    public val dataSourceArn: Output<String>,
    public val inputColumns: Output<List<DataSetPhysicalTableMapS3SourceInputColumnArgs>>,
    public val uploadSettings: Output<DataSetPhysicalTableMapS3SourceUploadSettingsArgs>,
) : ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceArgs.builder()
            .dataSourceArn(dataSourceArn.applyValue({ args0 -> args0 }))
            .inputColumns(
                inputColumns.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .uploadSettings(
                uploadSettings.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DataSetPhysicalTableMapS3SourceArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapS3SourceArgsBuilder internal constructor() {
    private var dataSourceArn: Output<String>? = null

    private var inputColumns: Output<List<DataSetPhysicalTableMapS3SourceInputColumnArgs>>? = null

    private var uploadSettings: Output<DataSetPhysicalTableMapS3SourceUploadSettingsArgs>? = null

    /**
     * @param value ARN of the data source.
     */
    @JvmName("ihsucvarcwrmosak")
    public suspend fun dataSourceArn(`value`: Output<String>) {
        this.dataSourceArn = value
    }

    /**
     * @param value Column schema of the table. See input_columns.
     */
    @JvmName("noedmdtiyddtxiqp")
    public suspend fun inputColumns(`value`: Output<List<DataSetPhysicalTableMapS3SourceInputColumnArgs>>) {
        this.inputColumns = value
    }

    @JvmName("fobtjwavpvcvajhr")
    public suspend fun inputColumns(vararg values: Output<DataSetPhysicalTableMapS3SourceInputColumnArgs>) {
        this.inputColumns = Output.all(values.asList())
    }

    /**
     * @param values Column schema of the table. See input_columns.
     */
    @JvmName("ejwfengjkvyvpwwp")
    public suspend fun inputColumns(values: List<Output<DataSetPhysicalTableMapS3SourceInputColumnArgs>>) {
        this.inputColumns = Output.all(values)
    }

    /**
     * @param value Information about the format for the S3 source file or files. See upload_settings.
     */
    @JvmName("jngnlrppcsawalkf")
    public suspend fun uploadSettings(`value`: Output<DataSetPhysicalTableMapS3SourceUploadSettingsArgs>) {
        this.uploadSettings = value
    }

    /**
     * @param value ARN of the data source.
     */
    @JvmName("lthcpqyigfqlcdvw")
    public suspend fun dataSourceArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataSourceArn = mapped
    }

    /**
     * @param value Column schema of the table. See input_columns.
     */
    @JvmName("hxkijweuybphwgst")
    public suspend fun inputColumns(`value`: List<DataSetPhysicalTableMapS3SourceInputColumnArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("gsvrbsgvpmdqnxqs")
    public suspend fun inputColumns(argument: List<suspend DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("nnxdrchnidneenpc")
    public suspend fun inputColumns(vararg argument: suspend DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param argument Column schema of the table. See input_columns.
     */
    @JvmName("kwihbyyvvrqcunwr")
    public suspend fun inputColumns(argument: suspend DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.inputColumns = mapped
    }

    /**
     * @param values Column schema of the table. See input_columns.
     */
    @JvmName("yvroldukdketqelj")
    public suspend fun inputColumns(vararg values: DataSetPhysicalTableMapS3SourceInputColumnArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputColumns = mapped
    }

    /**
     * @param value Information about the format for the S3 source file or files. See upload_settings.
     */
    @JvmName("ixokhhbtcpryjerl")
    public suspend fun uploadSettings(`value`: DataSetPhysicalTableMapS3SourceUploadSettingsArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uploadSettings = mapped
    }

    /**
     * @param argument Information about the format for the S3 source file or files. See upload_settings.
     */
    @JvmName("lolyoennmttnvajf")
    public suspend fun uploadSettings(argument: suspend DataSetPhysicalTableMapS3SourceUploadSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DataSetPhysicalTableMapS3SourceUploadSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.uploadSettings = mapped
    }

    internal fun build(): DataSetPhysicalTableMapS3SourceArgs = DataSetPhysicalTableMapS3SourceArgs(
        dataSourceArn = dataSourceArn ?: throw PulumiNullFieldException("dataSourceArn"),
        inputColumns = inputColumns ?: throw PulumiNullFieldException("inputColumns"),
        uploadSettings = uploadSettings ?: throw PulumiNullFieldException("uploadSettings"),
    )
}
