@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.quicksight.kotlin.inputs

import com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of this column in the underlying data source.
 * @property type Data type of the column.
 */
public data class DataSetPhysicalTableMapS3SourceInputColumnArgs(
    public val name: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs> {
    override fun toJava(): com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs =
        com.pulumi.aws.quicksight.inputs.DataSetPhysicalTableMapS3SourceInputColumnArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DataSetPhysicalTableMapS3SourceInputColumnArgs].
 */
@PulumiTagMarker
public class DataSetPhysicalTableMapS3SourceInputColumnArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Name of this column in the underlying data source.
     */
    @JvmName("omdblkenjkhyqkjj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("untnfkadwwasfbqf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Name of this column in the underlying data source.
     */
    @JvmName("vbycvkeeuyjsmvhi")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Data type of the column.
     */
    @JvmName("awlynunabbquwubm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DataSetPhysicalTableMapS3SourceInputColumnArgs =
        DataSetPhysicalTableMapS3SourceInputColumnArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
